import React from 'react';
import { getHours, getHoursMinutes, getISOLocalDate, getISOLocalDateTime, } from '@wojtekmaj/date-utils';
export default function NativeInput(_a) {
    var ariaLabel = _a.ariaLabel, disabled = _a.disabled, maxDate = _a.maxDate, minDate = _a.minDate, name = _a.name, onChange = _a.onChange, required = _a.required, value = _a.value, valueType = _a.valueType;
    var nativeValueParser = (function () {
        switch (valueType) {
            case 'hour':
                return function (receivedValue) {
                    return "".concat(getISOLocalDate(receivedValue), "T").concat(getHours(receivedValue), ":00");
                };
            case 'minute':
                return function (receivedValue) {
                    return "".concat(getISOLocalDate(receivedValue), "T").concat(getHoursMinutes(receivedValue));
                };
            case 'second':
                return getISOLocalDateTime;
            default:
                throw new Error('Invalid valueType');
        }
    })();
    var step = (function () {
        switch (valueType) {
            case 'hour':
                return 3600;
            case 'minute':
                return 60;
            case 'second':
                return 1;
            default:
                throw new Error('Invalid valueType');
        }
    })();
    function stopPropagation(event) {
        event.stopPropagation();
    }
    return (React.createElement("input", { "aria-label": ariaLabel, disabled: disabled, hidden: true, max: maxDate ? nativeValueParser(maxDate) : undefined, min: minDate ? nativeValueParser(minDate) : undefined, name: name, onChange: onChange, onFocus: stopPropagation, required: required, step: step, style: {
            visibility: 'hidden',
            position: 'absolute',
            zIndex: '-999',
        }, type: "datetime-local", value: value ? nativeValueParser(value) : '' }));
}
