import React from 'react';
import makeEventProps from 'make-event-props';
import Calendar from 'react-calendar';
import Clock from 'react-clock';
import type { ReactNodeArray } from 'prop-types';
import type { ClassName, CloseReason, Detail, LooseValue, OpenReason, Value } from './shared/types.js';
type Icon = React.ReactElement | ReactNodeArray | null | string | number | boolean;
type IconOrRenderFunction = Icon | React.ComponentType | React.ReactElement;
type CalendarProps = Omit<React.ComponentPropsWithoutRef<typeof Calendar>, 'className' | 'maxDetail' | 'onChange'>;
type ClockProps = Omit<React.ComponentPropsWithoutRef<typeof Clock>, 'value'>;
type EventProps = ReturnType<typeof makeEventProps>;
export type DateTimePickerProps = {
    amPmAriaLabel?: string;
    autoFocus?: boolean;
    calendarAriaLabel?: string;
    calendarClassName?: ClassName;
    calendarIcon?: IconOrRenderFunction | null;
    className?: ClassName;
    clearAriaLabel?: string;
    clearIcon?: IconOrRenderFunction | null;
    clockClassName?: ClassName;
    closeWidgets?: boolean;
    'data-testid'?: string;
    dayAriaLabel?: string;
    dayPlaceholder?: string;
    disableCalendar?: boolean;
    disableClock?: boolean;
    disabled?: boolean;
    format?: string;
    hourAriaLabel?: string;
    hourPlaceholder?: string;
    id?: string;
    isCalendarOpen?: boolean;
    isClockOpen?: boolean;
    locale?: string;
    maxDate?: Date;
    maxDetail?: Detail;
    minDate?: Date;
    minuteAriaLabel?: string;
    minutePlaceholder?: string;
    monthAriaLabel?: string;
    monthPlaceholder?: string;
    name?: string;
    nativeInputAriaLabel?: string;
    onCalendarClose?: () => void;
    onCalendarOpen?: () => void;
    onChange?: (value: Value) => void;
    onClockClose?: () => void;
    onClockOpen?: () => void;
    onFocus?: (event: React.FocusEvent<HTMLDivElement>) => void;
    onInvalidChange?: () => void;
    openWidgetsOnFocus?: boolean;
    portalContainer?: HTMLElement | null;
    required?: boolean;
    secondAriaLabel?: string;
    secondPlaceholder?: string;
    shouldCloseWidgets?: (props: {
        reason: CloseReason;
        widget: 'calendar' | 'clock';
    }) => boolean;
    shouldOpenWidgets?: (props: {
        reason: OpenReason;
        widget: 'calendar' | 'clock';
    }) => boolean;
    showLeadingZeros?: boolean;
    value?: LooseValue;
    yearAriaLabel?: string;
    yearPlaceholder?: string;
} & CalendarProps & ClockProps & Omit<EventProps, 'onChange' | 'onFocus'>;
declare const DateTimePicker: React.FC<DateTimePickerProps>;
export default DateTimePicker;
