"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DayPicker = DayPicker;
const react_1 = __importStar(require("react"));
const UI_js_1 = require("./UI.js");
const getClassNamesForModifiers_js_1 = require("./helpers/getClassNamesForModifiers.js");
const getComponents_js_1 = require("./helpers/getComponents.js");
const getDataAttributes_js_1 = require("./helpers/getDataAttributes.js");
const getDateLib_js_1 = require("./helpers/getDateLib.js");
const getDefaultClassNames_js_1 = require("./helpers/getDefaultClassNames.js");
const getFormatters_js_1 = require("./helpers/getFormatters.js");
const getMonthOptions_js_1 = require("./helpers/getMonthOptions.js");
const getStyleForModifiers_js_1 = require("./helpers/getStyleForModifiers.js");
const getWeekdays_js_1 = require("./helpers/getWeekdays.js");
const getYearOptions_js_1 = require("./helpers/getYearOptions.js");
const defaultLabels = __importStar(require("./labels/index.js"));
const useCalendar_js_1 = require("./useCalendar.js");
const useDayPicker_js_1 = require("./useDayPicker.js");
const useFocus_js_1 = require("./useFocus.js");
const useGetModifiers_js_1 = require("./useGetModifiers.js");
const useSelection_js_1 = require("./useSelection.js");
const rangeIncludesDate_js_1 = require("./utils/rangeIncludesDate.js");
const typeguards_js_1 = require("./utils/typeguards.js");
/**
 * Render the date picker calendar.
 *
 * @group DayPicker
 * @see https://daypicker.dev
 */
function DayPicker(props) {
    const { components, formatters, labels, dateLib, classNames } = (0, react_1.useMemo)(() => ({
        dateLib: (0, getDateLib_js_1.getDateLib)(props.dateLib),
        components: (0, getComponents_js_1.getComponents)(props.components),
        formatters: (0, getFormatters_js_1.getFormatters)(props.formatters),
        labels: { ...defaultLabels, ...props.labels },
        classNames: { ...(0, getDefaultClassNames_js_1.getDefaultClassNames)(), ...props.classNames }
    }), [
        props.classNames,
        props.components,
        props.dateLib,
        props.formatters,
        props.labels
    ]);
    const { captionLayout, firstWeekContainsDate, locale, mode, onDayBlur, onDayClick, onDayFocus, onDayKeyDown, onNextClick, onPrevClick, showWeekNumber, styles, useAdditionalDayOfYearTokens, useAdditionalWeekYearTokens, weekStartsOn } = props;
    const formatOptions = {
        locale,
        weekStartsOn,
        firstWeekContainsDate,
        useAdditionalWeekYearTokens,
        useAdditionalDayOfYearTokens
    };
    const labelOptions = formatOptions;
    const { formatCaption, formatDay, formatMonthDropdown, formatWeekNumber, formatWeekNumberHeader, formatWeekdayName, formatYearDropdown } = formatters;
    const calendar = (0, useCalendar_js_1.useCalendar)(props, dateLib);
    const { days, months, navStart, navEnd, previousMonth, nextMonth, goToMonth } = calendar;
    const getModifiers = (0, useGetModifiers_js_1.useGetModifiers)(days, props, dateLib);
    const { isSelected, select, selected: selectedValue } = (0, useSelection_js_1.useSelection)(props, dateLib) ?? {};
    const { blur, focused, isFocusTarget, moveFocus, setFocused } = (0, useFocus_js_1.useFocus)(props, calendar, getModifiers, isSelected ?? (() => false), dateLib);
    const { labelDayButton, labelGridcell, labelGrid, labelMonthDropdown, labelNav, labelNext, labelPrevious, labelWeekday, labelWeekNumber, labelWeekNumberHeader, labelYearDropdown } = labels;
    const weekdays = (0, react_1.useMemo)(() => (0, getWeekdays_js_1.getWeekdays)(locale, props.weekStartsOn, props.ISOWeek, dateLib), [dateLib, locale, props.ISOWeek, props.weekStartsOn]);
    const isInteractive = mode !== undefined || onDayClick !== undefined;
    const handlePreviousClick = (0, react_1.useCallback)(() => {
        if (!previousMonth)
            return;
        goToMonth(previousMonth);
        onPrevClick?.(previousMonth);
    }, [previousMonth, goToMonth, onPrevClick]);
    const handleNextClick = (0, react_1.useCallback)(() => {
        if (!nextMonth)
            return;
        goToMonth(nextMonth);
        onNextClick?.(nextMonth);
    }, [goToMonth, nextMonth, onNextClick]);
    const handleDayClick = (0, react_1.useCallback)((day, m) => (e) => {
        e.preventDefault();
        e.stopPropagation();
        setFocused(day);
        select?.(day.date, m, e);
        onDayClick?.(day.date, m, e);
    }, [select, onDayClick, setFocused]);
    const handleDayFocus = (0, react_1.useCallback)((day, m) => (e) => {
        setFocused(day);
        onDayFocus?.(day.date, m, e);
    }, [onDayFocus, setFocused]);
    const handleDayBlur = (0, react_1.useCallback)((day, m) => (e) => {
        blur();
        onDayBlur?.(day.date, m, e);
    }, [blur, onDayBlur]);
    const handleDayKeyDown = (0, react_1.useCallback)((day, modifiers) => (e) => {
        const keyMap = {
            ArrowLeft: ["day", props.dir === "rtl" ? "after" : "before"],
            ArrowRight: ["day", props.dir === "rtl" ? "before" : "after"],
            ArrowDown: ["week", "after"],
            ArrowUp: ["week", "before"],
            PageUp: [e.shiftKey ? "year" : "month", "before"],
            PageDown: [e.shiftKey ? "year" : "month", "after"],
            Home: ["startOfWeek", "before"],
            End: ["endOfWeek", "after"]
        };
        if (keyMap[e.key]) {
            e.preventDefault();
            e.stopPropagation();
            const [moveBy, moveDir] = keyMap[e.key];
            moveFocus(moveBy, moveDir);
        }
        onDayKeyDown?.(day.date, modifiers, e);
    }, [moveFocus, onDayKeyDown, props.dir]);
    const { className, style } = (0, react_1.useMemo)(() => ({
        className: [classNames[UI_js_1.UI.Root], props.className]
            .filter(Boolean)
            .join(" "),
        style: { ...styles?.[UI_js_1.UI.Root], ...props.style }
    }), [classNames, props.className, props.style, styles]);
    const dataAttributes = (0, getDataAttributes_js_1.getDataAttributes)(props);
    const contextValue = {
        selected: selectedValue,
        select: select,
        isSelected,
        months,
        nextMonth,
        previousMonth,
        goToMonth,
        getModifiers
    };
    return (react_1.default.createElement(useDayPicker_js_1.dayPickerContext.Provider, { value: contextValue },
        react_1.default.createElement(components.Root, { className: className, style: style, dir: props.dir, id: props.id, lang: props.lang, nonce: props.nonce, title: props.title, ...dataAttributes },
            react_1.default.createElement(components.Months, { className: classNames[UI_js_1.UI.Months], style: styles?.[UI_js_1.UI.Months] },
                !props.hideNavigation && (react_1.default.createElement(components.Nav, { role: "navigation", className: classNames[UI_js_1.UI.Nav], style: styles?.[UI_js_1.UI.Nav], "aria-label": labelNav() },
                    react_1.default.createElement(components.Button, { type: "button", className: classNames[UI_js_1.UI.ButtonPrevious], tabIndex: previousMonth ? undefined : -1, disabled: previousMonth ? undefined : true, "aria-label": labelPrevious(previousMonth, labelOptions), onClick: handlePreviousClick },
                        react_1.default.createElement(components.Chevron, { disabled: previousMonth ? undefined : true, className: classNames[UI_js_1.UI.Chevron], orientation: "left" })),
                    react_1.default.createElement(components.Button, { type: "button", className: classNames[UI_js_1.UI.ButtonNext], tabIndex: nextMonth ? undefined : -1, disabled: nextMonth ? undefined : true, "aria-label": labelNext(nextMonth, labelOptions), onClick: handleNextClick },
                        react_1.default.createElement(components.Chevron, { disabled: previousMonth ? undefined : true, orientation: "right", className: classNames[UI_js_1.UI.Chevron] })))),
                months.map((calendarMonth, displayIndex) => {
                    const handleMonthChange = (e) => {
                        const selectedMonth = Number(e.target.value);
                        const month = dateLib.setMonth(dateLib.startOfMonth(calendarMonth.date), selectedMonth);
                        goToMonth(month);
                    };
                    const handleYearChange = (e) => {
                        const month = dateLib.setYear(dateLib.startOfMonth(calendarMonth.date), Number(e.target.value));
                        goToMonth(month);
                    };
                    const dropdownMonths = (0, getMonthOptions_js_1.getMonthOptions)(calendarMonth.date, navStart, navEnd, formatters, locale, dateLib);
                    const dropdownYears = (0, getYearOptions_js_1.getYearOptions)(months[0].date, navStart, navEnd, formatters, dateLib);
                    return (react_1.default.createElement(components.Month, { className: classNames[UI_js_1.UI.Month], style: styles?.[UI_js_1.UI.Month], key: displayIndex, displayIndex: displayIndex, calendarMonth: calendarMonth },
                        react_1.default.createElement(components.MonthCaption, { className: classNames[UI_js_1.UI.MonthCaption], style: styles?.[UI_js_1.UI.MonthCaption], calendarMonth: calendarMonth, displayIndex: displayIndex }, captionLayout?.startsWith("dropdown") ? (react_1.default.createElement(components.DropdownNav, { className: classNames[UI_js_1.UI.Dropdowns], style: styles?.[UI_js_1.UI.Dropdowns] },
                            captionLayout === "dropdown" ||
                                captionLayout === "dropdown-months" ? (react_1.default.createElement(components.Dropdown, { "aria-label": labelMonthDropdown(), classNames: classNames, components: components, disabled: Boolean(props.disableNavigation), onChange: handleMonthChange, options: dropdownMonths, style: styles?.[UI_js_1.UI.Dropdown], value: calendarMonth.date.getMonth() })) : (react_1.default.createElement("span", { role: "status", "aria-live": "polite" }, formatMonthDropdown(calendarMonth.date.getMonth()))),
                            captionLayout === "dropdown" ||
                                captionLayout === "dropdown-years" ? (react_1.default.createElement(components.Dropdown, { "aria-label": labelYearDropdown(labelOptions), classNames: classNames, components: components, disabled: Boolean(props.disableNavigation), onChange: handleYearChange, options: dropdownYears, style: styles?.[UI_js_1.UI.Dropdown], value: calendarMonth.date.getFullYear() })) : (react_1.default.createElement("span", { role: "status", "aria-live": "polite" }, formatYearDropdown(calendarMonth.date.getFullYear()))))) : (react_1.default.createElement(components.CaptionLabel, { className: classNames[UI_js_1.UI.CaptionLabel], role: "status", "aria-live": "polite" }, formatCaption(calendarMonth.date, formatOptions, dateLib)))),
                        react_1.default.createElement(components.MonthGrid, { role: "grid", "aria-multiselectable": mode === "multiple" || mode === "range", "aria-label": labelGrid(calendarMonth.date, labelOptions, dateLib) ||
                                undefined, className: classNames[UI_js_1.UI.MonthGrid], style: styles?.[UI_js_1.UI.MonthGrid] },
                            !props.hideWeekdays && (react_1.default.createElement(components.Weekdays, { className: classNames[UI_js_1.UI.Weekdays], role: "row", style: styles?.[UI_js_1.UI.Weekdays] },
                                showWeekNumber && (react_1.default.createElement(components.WeekNumberHeader, { "aria-label": labelWeekNumberHeader(labelOptions), className: classNames[UI_js_1.UI.WeekNumberHeader], role: "columnheader", style: styles?.[UI_js_1.UI.WeekNumberHeader] }, formatWeekNumberHeader())),
                                weekdays.map((weekday, i) => (react_1.default.createElement(components.Weekday, { "aria-label": labelWeekday(weekday, labelOptions, dateLib), className: classNames[UI_js_1.UI.Weekday], key: i, role: "columnheader", style: styles?.[UI_js_1.UI.Weekday] }, formatWeekdayName(weekday, formatOptions, dateLib)))))),
                            react_1.default.createElement(components.Weeks, { className: classNames[UI_js_1.UI.Weeks], role: "rowgroup", style: styles?.[UI_js_1.UI.Weeks] }, calendarMonth.weeks.map((week, weekIndex) => {
                                return (react_1.default.createElement(components.Week, { className: classNames[UI_js_1.UI.Week], key: week.weekNumber, role: "row", style: styles?.[UI_js_1.UI.Week], week: week },
                                    showWeekNumber && (react_1.default.createElement(components.WeekNumber, { week: week, role: "rowheader", style: styles?.[UI_js_1.UI.WeekNumber], "aria-label": labelWeekNumber(week.weekNumber, {
                                            locale
                                        }), className: classNames[UI_js_1.UI.WeekNumber] }, formatWeekNumber(week.weekNumber))),
                                    week.days.map((day) => {
                                        const { date } = day;
                                        const modifiers = getModifiers(day);
                                        modifiers[UI_js_1.DayFlag.focused] =
                                            !modifiers.hidden &&
                                                Boolean(focused?.isEqualTo(day));
                                        modifiers[UI_js_1.SelectionState.selected] =
                                            !modifiers.disabled &&
                                                (isSelected?.(date) || modifiers.selected);
                                        if ((0, typeguards_js_1.isDateRange)(selectedValue)) {
                                            // add range modifiers
                                            const { from, to } = selectedValue;
                                            modifiers[UI_js_1.SelectionState.range_start] = Boolean(from && to && dateLib.isSameDay(date, from));
                                            modifiers[UI_js_1.SelectionState.range_end] = Boolean(from && to && dateLib.isSameDay(date, to));
                                            modifiers[UI_js_1.SelectionState.range_middle] =
                                                (0, rangeIncludesDate_js_1.rangeIncludesDate)(selectedValue, date, true, dateLib);
                                        }
                                        const style = (0, getStyleForModifiers_js_1.getStyleForModifiers)(modifiers, styles, props.modifiersStyles);
                                        const className = (0, getClassNamesForModifiers_js_1.getClassNamesForModifiers)(modifiers, classNames, props.modifiersClassNames);
                                        const ariaLabel = !isInteractive
                                            ? labelGridcell(date, modifiers, labelOptions, dateLib)
                                            : undefined;
                                        const dataAttributes = {
                                            "data-day": dateLib.format(date, "yyyy-MM-dd"),
                                            "data-month": day.outside
                                                ? dateLib.format(date, "yyyy-MM")
                                                : undefined
                                        };
                                        return (react_1.default.createElement(components.Day, { key: `${dateLib.format(date, "yyyy-MM-dd")}_${dateLib.format(day.displayMonth, "yyyy-MM")}`, day: day, modifiers: modifiers, role: "gridcell", className: className.join(" "), style: style, "aria-hidden": modifiers.hidden || undefined, "aria-selected": modifiers.selected || undefined, "aria-label": ariaLabel, ...dataAttributes }, isInteractive ? (react_1.default.createElement(components.DayButton, { className: classNames[UI_js_1.UI.DayButton], style: styles?.[UI_js_1.UI.DayButton], day: day, modifiers: modifiers, disabled: modifiers.disabled || undefined, tabIndex: isFocusTarget(day) ? 0 : -1, "aria-label": labelDayButton(date, modifiers, labelOptions, dateLib), onClick: handleDayClick(day, modifiers), onBlur: handleDayBlur(day, modifiers), onFocus: handleDayFocus(day, modifiers), onKeyDown: handleDayKeyDown(day, modifiers) }, formatDay(date, formatOptions, dateLib))) : (formatDay(day.date, formatOptions, dateLib))));
                                    })));
                            })))));
                })),
            props.footer && (react_1.default.createElement(components.Footer, { className: classNames[UI_js_1.UI.Footer], style: styles?.[UI_js_1.UI.Footer], role: "status", "aria-live": "polite" }, props.footer)))));
}
//# sourceMappingURL=DayPicker.js.map