import React from "react";
import type { CalendarDay } from "../classes/index.js";
import type { Modifiers } from "../types/index.js";
/**
 * Render the button for a day in the calendar.
 *
 * When not interactive, DayPicker will render a `DayContent` component instead
 * of a `DayButton` component.
 *
 * @group Components
 * @see https://daypicker.dev/guides/custom-components
 */
export declare function DayButton(props: {
    /** The day to render. */
    day: CalendarDay;
    /** The modifiers for the day. */
    modifiers: Modifiers;
} & JSX.IntrinsicElements["button"]): React.JSX.Element;
export type DayButtonProps = Parameters<typeof DayButton>[0];
