"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatMonthDropdown = formatMonthDropdown;
const locales_js_1 = require("../lib/locales.js");
/**
 * Format the month number for the dropdown option label.
 *
 * @defaultValue The localized month name
 * @group Formatters
 * @see https://daypicker.dev/docs/translation#custom-formatters
 */
function formatMonthDropdown(
/** The month number to format. */
monthNumber, 
/** The locale to use for formatting. */
locale = locales_js_1.enUS) {
    return locale.localize?.month(monthNumber);
}
//# sourceMappingURL=formatMonthDropdown.js.map