"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.labelGridcell = labelGridcell;
const index_js_1 = require("../lib/index.js");
/**
 * The label for the day gridcell when the calendar is not interactive.
 *
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
function labelGridcell(date, 
/** The modifiers for the day. */
modifiers, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    let label = dateLib.format(date, "PPPP", options);
    if (modifiers?.today) {
        label = `Today, ${label}`;
    }
    return label;
}
//# sourceMappingURL=labelGridcell.js.map