"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.labelWeekday = labelWeekday;
const index_js_1 = require("../lib/index.js");
/**
 * The ARIA label for the Weekday column header.
 *
 * @defaultValue `"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"`
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
function labelWeekday(date, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    return dateLib.format(date, "cccc", options);
}
//# sourceMappingURL=labelWeekday.js.map