"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dateLib = void 0;
const addDays_1 = require("date-fns/addDays");
const addMonths_1 = require("date-fns/addMonths");
const addWeeks_1 = require("date-fns/addWeeks");
const addYears_1 = require("date-fns/addYears");
const differenceInCalendarDays_1 = require("date-fns/differenceInCalendarDays");
const differenceInCalendarMonths_1 = require("date-fns/differenceInCalendarMonths");
const endOfISOWeek_1 = require("date-fns/endOfISOWeek");
const endOfMonth_1 = require("date-fns/endOfMonth");
const endOfWeek_1 = require("date-fns/endOfWeek");
const endOfYear_1 = require("date-fns/endOfYear");
const format_1 = require("date-fns/format");
const getISOWeek_1 = require("date-fns/getISOWeek");
const getWeek_1 = require("date-fns/getWeek");
const isAfter_1 = require("date-fns/isAfter");
const isBefore_1 = require("date-fns/isBefore");
const isDate_1 = require("date-fns/isDate");
const isSameDay_1 = require("date-fns/isSameDay");
const isSameMonth_1 = require("date-fns/isSameMonth");
const isSameYear_1 = require("date-fns/isSameYear");
const max_1 = require("date-fns/max");
const min_1 = require("date-fns/min");
const setMonth_1 = require("date-fns/setMonth");
const setYear_1 = require("date-fns/setYear");
const startOfDay_1 = require("date-fns/startOfDay");
const startOfISOWeek_1 = require("date-fns/startOfISOWeek");
const startOfMonth_1 = require("date-fns/startOfMonth");
const startOfWeek_1 = require("date-fns/startOfWeek");
const startOfYear_1 = require("date-fns/startOfYear");
/**
 * The default date library to use with the date picker.
 *
 * @private
 * @internal
 */
exports.dateLib = {
    /** The constructor of the date object. */
    Date: Date,
    addDays: addDays_1.addDays,
    addMonths: addMonths_1.addMonths,
    addWeeks: addWeeks_1.addWeeks,
    addYears: addYears_1.addYears,
    differenceInCalendarDays: differenceInCalendarDays_1.differenceInCalendarDays,
    differenceInCalendarMonths: differenceInCalendarMonths_1.differenceInCalendarMonths,
    endOfISOWeek: endOfISOWeek_1.endOfISOWeek,
    endOfMonth: endOfMonth_1.endOfMonth,
    endOfWeek: endOfWeek_1.endOfWeek,
    endOfYear: endOfYear_1.endOfYear,
    format: format_1.format,
    getISOWeek: getISOWeek_1.getISOWeek,
    getWeek: getWeek_1.getWeek,
    isAfter: isAfter_1.isAfter,
    isBefore: isBefore_1.isBefore,
    isDate: isDate_1.isDate,
    isSameDay: isSameDay_1.isSameDay,
    isSameMonth: isSameMonth_1.isSameMonth,
    isSameYear: isSameYear_1.isSameYear,
    max: max_1.max,
    min: min_1.min,
    setMonth: setMonth_1.setMonth,
    setYear: setYear_1.setYear,
    startOfDay: startOfDay_1.startOfDay,
    startOfISOWeek: startOfISOWeek_1.startOfISOWeek,
    startOfMonth: startOfMonth_1.startOfMonth,
    startOfWeek: startOfWeek_1.startOfWeek,
    startOfYear: startOfYear_1.startOfYear
};
//# sourceMappingURL=dateLib.js.map