"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRange = useRange;
const react_1 = __importDefault(require("react"));
const index_js_1 = require("../utils/index.js");
const rangeIncludesDate_js_1 = require("../utils/rangeIncludesDate.js");
function useRange(props, dateLib) {
    const { mode, disabled, excludeDisabled, selected: initiallySelected, required, onSelect } = props;
    const { differenceInCalendarDays } = dateLib;
    const [selected, setSelected] = react_1.default.useState(initiallySelected);
    // Update the selected date if the required flag is set.
    react_1.default.useEffect(() => {
        if (required && selected === undefined) {
            setSelected({ from: undefined, to: undefined });
        }
    }, [required, selected, mode]);
    // Update the selected date if the `selected` prop changes.
    react_1.default.useEffect(() => {
        setSelected(initiallySelected);
    }, [initiallySelected]);
    const isSelected = (date) => selected && (0, rangeIncludesDate_js_1.rangeIncludesDate)(selected, date, false, dateLib);
    const select = (triggerDate, modifiers, e) => {
        const newRange = triggerDate
            ? (0, index_js_1.addToRange)(triggerDate, selected, dateLib)
            : undefined;
        const { min, max } = props;
        if (min) {
            if (newRange?.from &&
                newRange.to &&
                differenceInCalendarDays(newRange.to, newRange.from) < min - 1) {
                newRange.from = triggerDate;
                newRange.to = undefined;
            }
        }
        if (max) {
            if (newRange?.from &&
                newRange.to &&
                differenceInCalendarDays(newRange.to, newRange.from) >= max) {
                newRange.from = triggerDate;
                newRange.to = undefined;
            }
        }
        if (newRange?.from && newRange.to) {
            let newDate = newRange.from;
            while (dateLib.differenceInCalendarDays(newRange.to, newDate) > 0) {
                newDate = dateLib.addDays(newDate, 1);
                if (excludeDisabled &&
                    disabled &&
                    (0, index_js_1.dateMatchModifiers)(newDate, disabled, dateLib)) {
                    newRange.from = triggerDate;
                    newRange.to = undefined;
                    break;
                }
            }
        }
        setSelected(newRange);
        onSelect?.(newRange, triggerDate, modifiers, e);
        return newRange;
    };
    return {
        selected,
        select,
        isSelected
    };
}
//# sourceMappingURL=useRange.js.map