"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dayPickerContext = void 0;
exports.useDayPicker = useDayPicker;
const react_1 = require("react");
// Create a context with a default value
exports.dayPickerContext = (0, react_1.createContext)(undefined);
/**
 * Return the context to work with `<DayPicker />` inside custom components.
 *
 * @group Hooks
 * @see https://daypicker.dev/guides/custom-components
 */
function useDayPicker(props) {
    const context = (0, react_1.useContext)(exports.dayPickerContext);
    if (context === undefined) {
        throw new Error("useDayPicker() must be used within a custom component.");
    }
    return context;
}
//# sourceMappingURL=useDayPicker.js.map