import { dateLib as defaultDateLib } from "../lib/index.js";
/**
 * Generate a series of 7 days, starting from the week, to use for formatting
 * the weekday names (Monday, Tuesday, etc.).
 */
export function getWeekdays(locale, 
/** The index of the first day of the week (0 - Sunday). */
weekStartsOn, 
/** Use ISOWeek instead of locale/ */
ISOWeek, 
/** @ignore */
dateLib = defaultDateLib) {
    const start = ISOWeek
        ? dateLib.startOfISOWeek(new dateLib.Date())
        : dateLib.startOfWeek(new dateLib.Date(), { locale, weekStartsOn });
    const days = [];
    for (let i = 0; i < 7; i++) {
        const day = dateLib.addDays(start, i);
        days.push(day);
    }
    return days;
}
//# sourceMappingURL=getWeekdays.js.map