import { dateLib as defaultDateLib } from "../lib/index.js";
/**
 * The label for the day gridcell when the calendar is not interactive.
 *
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
export function labelGridcell(date, 
/** The modifiers for the day. */
modifiers, options, 
/** @ignore */
dateLib = defaultDateLib) {
    let label = dateLib.format(date, "PPPP", options);
    if (modifiers?.today) {
        label = `Today, ${label}`;
    }
    return label;
}
//# sourceMappingURL=labelGridcell.js.map