import { CalendarDay } from "./classes/CalendarDay.js";
import { CalendarMonth } from "./classes/CalendarMonth.js";
import type { DayPickerProps } from "./types/props.js";
import type { SelectedValue, SelectHandler } from "./types/selection.js";
import { Modifiers } from "./types/shared.js";
export declare const dayPickerContext: import("react").Context<DayPickerContext<DayPickerProps> | undefined>;
export type DayPickerContext<T extends DayPickerProps> = {
    /** The months displayed in the calendar. */
    months: CalendarMonth[];
    /** The next month to display. */
    nextMonth: Date | undefined;
    /** The previous month to display. */
    previousMonth: Date | undefined;
    /** Navigate to the specified month. Will fire the `onMonthChange` callback. */
    goToMonth: (month: Date) => void;
    /** Returns the modifiers for the given day. */
    getModifiers: (day: CalendarDay) => Modifiers;
    /** The selected date(s). */
    selected: SelectedValue<T> | undefined;
    /** Set a selection. */
    select: SelectHandler<T> | undefined;
    /** Whether the given date is selected. */
    isSelected: ((date: Date) => boolean) | undefined;
};
/**
 * Return the context to work with `<DayPicker />` inside custom components.
 *
 * @group Hooks
 * @see https://daypicker.dev/guides/custom-components
 */
export declare function useDayPicker<T extends DayPickerProps>(props?: T): DayPickerContext<T>;
