"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatMonthCaption = void 0;
exports.formatCaption = formatCaption;
const index_js_1 = require("../lib/index.js");
/**
 * Format the caption of the month.
 *
 * @defaultValue `LLLL y` (e.g. "November 2022")
 * @group Formatters
 * @see https://daypicker.dev/docs/translation#custom-formatters
 */
function formatCaption(month, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    return dateLib.format(month, "LLLL y", options);
}
/**
 * @private
 * @deprecated Use {@link formatCaption} instead.
 * @group Formatters
 */
exports.formatMonthCaption = formatCaption;
//# sourceMappingURL=formatCaption.js.map