"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatDay = formatDay;
const index_js_1 = require("../lib/index.js");
/**
 * Format the day date shown in the day cell.
 *
 * @defaultValue `d` (e.g. "1")
 * @group Formatters
 * @see https://daypicker.dev/docs/translation#custom-formatters
 */
function formatDay(date, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    return dateLib.format(date, "d", options);
}
//# sourceMappingURL=formatDay.js.map