"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatWeekdayName = formatWeekdayName;
const index_js_1 = require("../lib/index.js");
/**
 * Format the weekday name to be displayed in the weekdays header.
 *
 * @defaultValue `cccccc` (e.g. "Mo" for Monday)
 * @group Formatters
 * @see https://daypicker.dev/docs/translation#custom-formatters
 */
function formatWeekdayName(weekday, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    return dateLib.format(weekday, "cccccc", options);
}
//# sourceMappingURL=formatWeekdayName.js.map