"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.labelDay = void 0;
exports.labelDayButton = labelDayButton;
const index_js_1 = require("../lib/index.js");
/**
 * The ARIA label for the day button.
 *
 * Use the `modifiers` argument to add additional context to the label, e.g.
 * when a day is selected or is today.
 *
 * @defaultValue The formatted date.
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
function labelDayButton(date, 
/** The modifiers for the day. */
modifiers, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    let label = dateLib.format(date, "PPPP", options);
    if (modifiers.today)
        label = `Today, ${label}`;
    if (modifiers.selected)
        label = `${label}, selected`;
    return label;
}
/** @deprecated Use `labelDayButton` instead. */
exports.labelDay = labelDayButton;
//# sourceMappingURL=labelDayButton.js.map