"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.labelCaption = void 0;
exports.labelGrid = labelGrid;
const index_js_1 = require("../lib/index.js");
/**
 * Return an ARIA label for the month grid, that will be announced when entering
 * the grid.
 *
 * @defaultValue `LLLL y` (e.g. "November 2022")
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
function labelGrid(date, options, 
/** @ignore */
dateLib = index_js_1.dateLib) {
    return dateLib.format(date, "LLLL y", options);
}
/**
 * @deprecated Use {@link labelGrid} instead.
 * @protected
 */
exports.labelCaption = labelGrid;
//# sourceMappingURL=labelGrid.js.map