"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useMulti = useMulti;
const react_1 = __importDefault(require("react"));
function useMulti(props, dateLib) {
    const { selected: initiallySelected, required, onSelect, mode } = props;
    const [selected, setSelected] = react_1.default.useState(initiallySelected);
    const { isSameDay, Date } = dateLib;
    // Update the selected date if the required flag is set.
    react_1.default.useEffect(() => {
        if (required && selected === undefined) {
            setSelected([new Date()]);
        }
    }, [required, selected, Date, mode]);
    // Update the selected date if the selected value from props changes.
    react_1.default.useEffect(() => {
        setSelected(initiallySelected);
    }, [mode, initiallySelected]);
    const isSelected = (date) => {
        return selected?.some((d) => isSameDay(d, date)) ?? false;
    };
    const { min, max } = props;
    const select = (triggerDate, modifiers, e) => {
        let newDates = [...(selected ?? [])];
        if (isSelected(triggerDate)) {
            if (selected?.length === min) {
                // Min value reached, do nothing
                return;
            }
            if (required && selected?.length === 1) {
                // Required value already selected do nothing
                return;
            }
            newDates = selected?.filter((d) => !isSameDay(d, triggerDate));
        }
        else {
            if (selected?.length === max) {
                // Max value reached, reset the selection to date
                newDates = [triggerDate];
            }
            else {
                // Add the date to the selection
                newDates = [...newDates, triggerDate];
            }
        }
        onSelect?.(newDates, triggerDate, modifiers, e);
        setSelected(newDates);
        return newDates;
    };
    return {
        selected,
        select,
        isSelected
    };
}
//# sourceMappingURL=useMulti.js.map