import type { CalendarWeek, CalendarDay, CalendarMonth } from "./classes/index.js";
import type { DayPickerProps } from "./types/props.js";
import type { DateLib } from "./types/shared.js";
/**
 * Return the calendar object to work with the calendar in custom components.
 *
 * @see https://daypicker.dev/guides/custom-components
 */
export interface Calendar {
    /**
     * All the days displayed in the calendar. As opposite from
     * {@link CalendarContext.dates}, it may return duplicated dates when shown
     * outside the month.
     */
    days: CalendarDay[];
    /** The months displayed in the calendar. */
    weeks: CalendarWeek[];
    /** The months displayed in the calendar. */
    months: CalendarMonth[];
    /** The next month to display. */
    nextMonth: Date | undefined;
    /** The previous month to display. */
    previousMonth: Date | undefined;
    /**
     * The month where the navigation starts. `undefined` if the calendar can be
     * navigated indefinitely to the past.
     */
    navStart: Date | undefined;
    /**
     * The month where the navigation ends. `undefined` if the calendar can be
     * navigated indefinitely to the past.
     */
    navEnd: Date | undefined;
    /** Navigate to the specified month. Will fire the `onMonthChange` callback. */
    goToMonth: (month: Date) => void;
    /**
     * Navigate to the specified date. If the second parameter (refDate) is
     * provided and the date is before the refDate, then the month is set to one
     * month before the date.
     *
     * @param day - The date to navigate to.
     * @param dateToCompare - Optional. If `date` is before `dateToCompare`, the
     *   month is set to one month before the date.
     */
    goToDay: (day: CalendarDay) => void;
}
/** @private */
export declare function useCalendar(props: DayPickerProps, dateLib: DateLib): Calendar;
