import { dateLib as defaultDateLib } from "../lib/index.js";
/**
 * The ARIA label for the day button.
 *
 * Use the `modifiers` argument to add additional context to the label, e.g.
 * when a day is selected or is today.
 *
 * @defaultValue The formatted date.
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
export function labelDayButton(date, 
/** The modifiers for the day. */
modifiers, options, 
/** @ignore */
dateLib = defaultDateLib) {
    let label = dateLib.format(date, "PPPP", options);
    if (modifiers.today)
        label = `Today, ${label}`;
    if (modifiers.selected)
        label = `${label}, selected`;
    return label;
}
/** @deprecated Use `labelDayButton` instead. */
export const labelDay = labelDayButton;
//# sourceMappingURL=labelDayButton.js.map