import { dateLib as defaultDateLib } from "../lib/index.js";
/**
 * The ARIA label for the Weekday column header.
 *
 * @defaultValue `"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"`
 * @group Labels
 * @see https://daypicker.dev/docs/translation#aria-labels
 */
export function labelWeekday(date, options, 
/** @ignore */
dateLib = defaultDateLib) {
    return dateLib.format(date, "cccc", options);
}
//# sourceMappingURL=labelWeekday.js.map