import { createContext, useContext } from "react";
// Create a context with a default value
export const dayPickerContext = createContext(undefined);
/**
 * Return the context to work with `<DayPicker />` inside custom components.
 *
 * @group Hooks
 * @see https://daypicker.dev/guides/custom-components
 */
export function useDayPicker(props) {
    const context = useContext(dayPickerContext);
    if (context === undefined) {
        throw new Error("useDayPicker() must be used within a custom component.");
    }
    return context;
}
//# sourceMappingURL=useDayPicker.js.map