'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = describe;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _descToJSON = require('./descToJSON');

var _descToJSON2 = _interopRequireDefault(_descToJSON);

var _descToMarkdown = require('./descToMarkdown');

var _descToMarkdown2 = _interopRequireDefault(_descToMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var convertArray = function convertArray(array) {
  return array.map(function (type) {
    return convertPropType(type);
  });
};

var convertShape = function convertShape(shape) {
  var result = {};
  Object.keys(shape).forEach(function (key) {
    result[key] = convertPropType(shape[key]);
  });
  return result;
};

var convertPropType = function convertPropType(propType) {
  var result = void 0;
  if (propType && propType.type) {
    if (!_propTypes2.default[propType.type]) {
      throw new Error('react-desc: unknown type ' + propType.type);
    }
    if (propType.args) {
      if (propType.type === 'oneOfType' || propType.type === 'arrayOf') {
        if (Array.isArray(propType.args)) {
          result = _propTypes2.default[propType.type](convertArray(propType.args));
        } else {
          result = _propTypes2.default[propType.type](convertPropType(propType.args));
        }
      } else if (propType.type === 'shape') {
        result = _propTypes2.default[propType.type](convertShape(propType.args));
      } else {
        result = _propTypes2.default[propType.type](propType.args);
      }
    } else {
      result = _propTypes2.default[propType.type];
    }
  } else {
    result = propType;
  }
  return result;
};

function describe(ComponentInstance) {
  if (!ComponentInstance) {
    throw new Error('react-desc: component is required');
  }

  var documentation = {
    propTypes: {}
  };

  /* eslint-disable react/prefer-stateless-function */

  var DocumentedComponent = function (_Component) {
    _inherits(DocumentedComponent, _Component);

    function DocumentedComponent() {
      _classCallCheck(this, DocumentedComponent);

      return _possibleConstructorReturn(this, (DocumentedComponent.__proto__ || Object.getPrototypeOf(DocumentedComponent)).apply(this, arguments));
    }

    _createClass(DocumentedComponent, [{
      key: 'render',
      value: function render() {
        return _react2.default.createElement(ComponentInstance, this.props);
      }
    }]);

    return DocumentedComponent;
  }(_react.Component);
  /* eslint-enable react/prefer-stateless-function */


  DocumentedComponent.WrappedComponent = ComponentInstance;
  DocumentedComponent.displayName = ComponentInstance.displayName || ComponentInstance.name;

  var addDocumentationProp = function addDocumentationProp(propName) {
    return function (value) {
      documentation[propName] = value;
      return DocumentedComponent;
    };
  };

  DocumentedComponent.availableAt = addDocumentationProp('availableAt');
  DocumentedComponent.description = addDocumentationProp('description');
  DocumentedComponent.deprecated = addDocumentationProp('deprecated');
  DocumentedComponent.usage = addDocumentationProp('usage');

  DocumentedComponent.toJSON = _descToJSON2.default.bind(null, ComponentInstance, documentation);
  DocumentedComponent.toMarkdown = _descToMarkdown2.default.bind(null, ComponentInstance, documentation);

  Object.defineProperty(DocumentedComponent, 'propTypes', {
    get: function get() {
      return DocumentedComponent.propTypesValue;
    },
    set: function set(value) {
      if (!DocumentedComponent.propTypesValue) {
        DocumentedComponent.propTypesValue = {};
      }
      Object.keys(value).forEach(function (name) {
        var propType = value[name];
        if (propType.type) {
          documentation.propTypes[name] = propType;
          propType = convertPropType(propType);
          if (value[name].reactDesc.required) {
            propType = propType.isRequired;
          }
        }
        DocumentedComponent.propTypesValue[name] = propType;
        return propType;
      });
    },
    enumerable: true,
    configurable: true
  });

  return DocumentedComponent;
}