'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _chai = require('chai');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _getDisplayName = require('../getDisplayName');

var _getDisplayName2 = _interopRequireDefault(_getDisplayName);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

describe('getDisplayName', function () {
  it('returns display name for component when displayName is set', function () {
    var Simple = function (_Component) {
      _inherits(Simple, _Component);

      function Simple() {
        _classCallCheck(this, Simple);

        return _possibleConstructorReturn(this, (Simple.__proto__ || Object.getPrototypeOf(Simple)).apply(this, arguments));
      }

      _createClass(Simple, [{
        key: 'render',
        value: function render() {
          return _react2.default.createElement('div', null);
        }
      }]);

      return Simple;
    }(_react.Component);

    Simple.displayName = 'Simple';
    (0, _chai.expect)((0, _getDisplayName2.default)(Simple)).to.equal('Simple');
  });
  it('returns display name for component when displayName is set from staic initializer', function () {
    var Simple = function (_Component2) {
      _inherits(Simple, _Component2);

      function Simple() {
        _classCallCheck(this, Simple);

        return _possibleConstructorReturn(this, (Simple.__proto__ || Object.getPrototypeOf(Simple)).apply(this, arguments));
      }

      _createClass(Simple, [{
        key: 'render',
        value: function render() {
          return _react2.default.createElement('div', null);
        }
      }]);

      return Simple;
    }(_react.Component);

    Simple.displayName = 'Simple';

    (0, _chai.expect)((0, _getDisplayName2.default)(Simple)).to.equal('Simple');
  });
  it('returns display name of html string component', function () {
    (0, _chai.expect)((0, _getDisplayName2.default)('input')).to.equal('input');
  });
  it('returns display name for a stateless component', function () {
    var Simple = function Simple() {
      return _react2.default.createElement('div', null);
    };

    (0, _chai.expect)((0, _getDisplayName2.default)(Simple)).to.equal('Simple');
  });
  it('returns display name for component', function () {
    var Simple = function (_Component3) {
      _inherits(Simple, _Component3);

      function Simple() {
        _classCallCheck(this, Simple);

        return _possibleConstructorReturn(this, (Simple.__proto__ || Object.getPrototypeOf(Simple)).apply(this, arguments));
      }

      _createClass(Simple, [{
        key: 'render',
        value: function render() {
          return _react2.default.createElement('div', null);
        }
      }]);

      return Simple;
    }(_react.Component);

    (0, _chai.expect)((0, _getDisplayName2.default)(Simple)).to.equal('Simple');
  });

  it('returns default display name non react classes', function () {
    var Simple = {};
    (0, _chai.expect)((0, _getDisplayName2.default)(Simple)).to.equal('Unknown');
  });

  it('returns default display name for stateless named functions', function () {
    var Named = function Example() {};
    (0, _chai.expect)((0, _getDisplayName2.default)(Named)).to.equal('Example');
  });

  it('returns default display name for stateless assigned functions', function () {
    var Assigned = function Assigned() {};
    (0, _chai.expect)((0, _getDisplayName2.default)(Assigned)).to.equal('Assigned');
  });

  it('returns default display name for stateless anonymous functions', function () {
    (0, _chai.expect)((0, _getDisplayName2.default)(function () {})).to.equal('Unknown');
  });

  it('wraps a component successfully (HoCs) ', function () {
    var container = function container(WrappedComponent) {
      var Container = function (_Component4) {
        _inherits(Container, _Component4);

        function Container() {
          _classCallCheck(this, Container);

          return _possibleConstructorReturn(this, (Container.__proto__ || Object.getPrototypeOf(Container)).apply(this, arguments));
        }

        _createClass(Container, [{
          key: 'render',
          value: function render() {
            return _react2.default.createElement(WrappedComponent, null);
          }
        }]);

        return Container;
      }(_react.Component);

      Container.displayName = 'Container(' + (0, _getDisplayName2.default)(WrappedComponent) + ')';

      return Container;
    };

    var HelloWorld = function (_Component5) {
      _inherits(HelloWorld, _Component5);

      function HelloWorld() {
        _classCallCheck(this, HelloWorld);

        return _possibleConstructorReturn(this, (HelloWorld.__proto__ || Object.getPrototypeOf(HelloWorld)).apply(this, arguments));
      }

      _createClass(HelloWorld, [{
        key: 'render',
        value: function render() {
          return _react2.default.createElement(
            'div',
            null,
            'Hello'
          );
        }
      }]);

      return HelloWorld;
    }(_react.Component);

    var HelloWorldPrime = container(HelloWorld);

    (0, _chai.expect)((0, _getDisplayName2.default)(HelloWorldPrime)).to.equal('Container(HelloWorld)');
    (0, _chai.expect)(HelloWorldPrime.displayName).to.equal('Container(HelloWorld)');
  });
});