'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultVerticalStrength = exports.defaultHorizontalStrength = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.createHorizontalStrength = createHorizontalStrength;
exports.createVerticalStrength = createVerticalStrength;
exports.default = createScrollingComponent;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _lodash = require('lodash.throttle');

var _lodash2 = _interopRequireDefault(_lodash);

var _raf = require('raf');

var _raf2 = _interopRequireDefault(_raf);

var _reactDisplayName = require('react-display-name');

var _reactDisplayName2 = _interopRequireDefault(_reactDisplayName);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _util = require('./util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DEFAULT_BUFFER = 150;

function createHorizontalStrength(_buffer) {
  return function defaultHorizontalStrength(_ref, point) {
    var x = _ref.x;
    var w = _ref.w;

    var buffer = Math.min(w / 2, _buffer);

    if (point.x >= x && point.x <= x + w) {
      if (point.x < x + buffer) {
        return (point.x - x - buffer) / buffer;
      } else if (point.x > x + w - buffer) {
        return -(x + w - point.x - buffer) / buffer;
      }
    }

    return 0;
  };
}

function createVerticalStrength(_buffer) {
  return function defaultVerticalStrength(_ref2, point) {
    var y = _ref2.y;
    var h = _ref2.h;

    var buffer = Math.min(h / 2, _buffer);

    if (point.y >= y && point.y <= y + h) {
      if (point.y < y + buffer) {
        return (point.y - y - buffer) / buffer;
      } else if (point.y > y + h - buffer) {
        return -(y + h - point.y - buffer) / buffer;
      }
    }

    return 0;
  };
}

var defaultHorizontalStrength = exports.defaultHorizontalStrength = createHorizontalStrength(DEFAULT_BUFFER);

var defaultVerticalStrength = exports.defaultVerticalStrength = createVerticalStrength(DEFAULT_BUFFER);

function createScrollingComponent(WrappedComponent) {
  var ScrollingComponent = function (_React$Component) {
    _inherits(ScrollingComponent, _React$Component);

    function ScrollingComponent(props, ctx) {
      _classCallCheck(this, ScrollingComponent);

      var _this = _possibleConstructorReturn(this, (ScrollingComponent.__proto__ || Object.getPrototypeOf(ScrollingComponent)).call(this, props, ctx));

      _this.handleDragOver = function (evt) {
        var _this$props;

        for (var _len = arguments.length, rest = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          rest[_key - 1] = arguments[_key];
        }

        // give users a chance to preventDefault
        if (typeof _this.props.onDragOver === 'function') (_this$props = _this.props).onDragOver.apply(_this$props, [evt].concat(rest));

        if (!_this.attached) {
          _this.attach();
          _this.updateScrolling(evt);
        }
      };

      _this.updateScrolling = (0, _lodash2.default)(function (evt) {
        var _this$container$getBo = _this.container.getBoundingClientRect();

        var x = _this$container$getBo.left;
        var y = _this$container$getBo.top;
        var w = _this$container$getBo.width;
        var h = _this$container$getBo.height;

        var box = { x: x, y: y, w: w, h: h };
        var coords = { x: evt.clientX, y: evt.clientY };

        // calculate strength
        _this.scaleX = _this.props.horizontalStrength(box, coords);
        _this.scaleY = _this.props.verticalStrength(box, coords);

        // start scrolling if we need to
        if (!_this.frame && (_this.scaleX || _this.scaleY)) _this.startScrolling();
      }, 100, { trailing: false });

      _this.stopScrolling = function () {
        if (_this.frame) {
          _this.detach();
          _raf2.default.cancel(_this.frame);
          _this.frame = null;
          _this.scaleX = 0;
          _this.scaleY = 0;
        }
      };

      _this.scaleX = 0;
      _this.scaleY = 0;
      _this.frame = null;
      _this.attached = false;
      return _this;
    }

    _createClass(ScrollingComponent, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        this.container = (0, _reactDom.findDOMNode)(this.wrappedInstance);
        this.container.addEventListener('dragover', this.handleDragOver);
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        if (this.frame) _raf2.default.cancel(this.frame);
        this.detach();
      }
    }, {
      key: 'attach',
      value: function attach() {
        window.document.body.addEventListener('dragover', this.updateScrolling);
        window.document.body.addEventListener('dragend', this.stopScrolling);
        window.document.body.addEventListener('drop', this.stopScrolling);
        this.attached = true;
      }
    }, {
      key: 'detach',
      value: function detach() {
        window.document.body.removeEventListener('dragover', this.updateScrolling);
        window.document.body.removeEventListener('dragend', this.stopScrolling);
        window.document.body.removeEventListener('drop', this.stopScrolling);
        this.attached = false;
      }

      // we don't care about the body's dragover events until this
      // component gets dragged over for the first time


      // Update scaleX and scaleY every 100ms or so
      // and start scrolling if necessary

    }, {
      key: 'startScrolling',
      value: function startScrolling() {
        var _this2 = this;

        var i = 0;
        var tick = function tick() {
          var scaleX = _this2.scaleX;
          var scaleY = _this2.scaleY;
          var container = _this2.container;
          var _props = _this2.props;
          var speed = _props.speed;
          var onScrollChange = _props.onScrollChange;

          // stop scrolling if there's nothing to do

          if (speed === 0 || scaleX + scaleY === 0) {
            _this2.stopScrolling();
            return;
          }

          // there's a bug in safari where it seems like we can't get
          // dragover events from a container that also emits a scroll
          // event that same frame. So we double the speed and only adjust
          // the scroll position at 30fps
          if (i++ % 2) {
            var scrollLeft = container.scrollLeft;
            var scrollTop = container.scrollTop;
            var scrollWidth = container.scrollWidth;
            var scrollHeight = container.scrollHeight;
            var clientWidth = container.clientWidth;
            var clientHeight = container.clientHeight;


            var newLeft = scaleX ? container.scrollLeft = (0, _util.intBetween)(0, scrollWidth - clientWidth, scrollLeft + scaleX * speed) : scrollLeft;

            var newTop = scaleY ? container.scrollTop = (0, _util.intBetween)(0, scrollHeight - clientHeight, scrollTop + scaleY * speed) : scrollTop;

            onScrollChange(newLeft, newTop);
          }
          _this2.frame = (0, _raf2.default)(tick);
        };

        tick();
      }
    }, {
      key: 'render',
      value: function render() {
        var _this3 = this;

        var _props2 = this.props;
        var speed = _props2.speed;
        var verticalStrength = _props2.verticalStrength;
        var horizontalStrength = _props2.horizontalStrength;
        var onScrollChange = _props2.onScrollChange;

        var props = _objectWithoutProperties(_props2, ['speed', 'verticalStrength', 'horizontalStrength', 'onScrollChange']);

        return _react2.default.createElement(WrappedComponent, _extends({
          ref: function ref(_ref3) {
            _this3.wrappedInstance = _ref3;
          }
        }, props));
      }
    }]);

    return ScrollingComponent;
  }(_react2.default.Component);

  ScrollingComponent.displayName = 'Scrolling(' + (0, _reactDisplayName2.default)(WrappedComponent) + ')';
  ScrollingComponent.propTypes = {
    onScrollChange: _react2.default.PropTypes.func,
    verticalStrength: _react2.default.PropTypes.func,
    horizontalStrength: _react2.default.PropTypes.func,
    speed: _react2.default.PropTypes.number
  };
  ScrollingComponent.defaultProps = {
    onScrollChange: _util.noop,
    verticalStrength: defaultVerticalStrength,
    horizontalStrength: defaultHorizontalStrength,
    speed: 30
  };


  return (0, _hoistNonReactStatics2.default)(ScrollingComponent, WrappedComponent);
}