'use strict';

exports.__esModule = true;
exports['default'] = createTargetMonitor;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var isCallingCanDrop = false;

var TargetMonitor = (function () {
  function TargetMonitor(manager) {
    _classCallCheck(this, TargetMonitor);

    this.internalMonitor = manager.getMonitor();
  }

  TargetMonitor.prototype.receiveHandlerId = function receiveHandlerId(targetId) {
    this.targetId = targetId;
  };

  TargetMonitor.prototype.canDrop = function canDrop() {
    (0, _invariant2['default'])(!isCallingCanDrop, 'You may not call monitor.canDrop() inside your canDrop() implementation. ' + 'Read more: http://gaearon.github.io/react-dnd/docs-drop-target-monitor.html');

    try {
      isCallingCanDrop = true;
      return this.internalMonitor.canDropOnTarget(this.targetId);
    } finally {
      isCallingCanDrop = false;
    }
  };

  TargetMonitor.prototype.isOver = function isOver(options) {
    return this.internalMonitor.isOverTarget(this.targetId, options);
  };

  TargetMonitor.prototype.getItemType = function getItemType() {
    return this.internalMonitor.getItemType();
  };

  TargetMonitor.prototype.getItem = function getItem() {
    return this.internalMonitor.getItem();
  };

  TargetMonitor.prototype.getDropResult = function getDropResult() {
    return this.internalMonitor.getDropResult();
  };

  TargetMonitor.prototype.didDrop = function didDrop() {
    return this.internalMonitor.didDrop();
  };

  TargetMonitor.prototype.getInitialClientOffset = function getInitialClientOffset() {
    return this.internalMonitor.getInitialClientOffset();
  };

  TargetMonitor.prototype.getInitialSourceClientOffset = function getInitialSourceClientOffset() {
    return this.internalMonitor.getInitialSourceClientOffset();
  };

  TargetMonitor.prototype.getSourceClientOffset = function getSourceClientOffset() {
    return this.internalMonitor.getSourceClientOffset();
  };

  TargetMonitor.prototype.getClientOffset = function getClientOffset() {
    return this.internalMonitor.getClientOffset();
  };

  TargetMonitor.prototype.getDifferenceFromInitialOffset = function getDifferenceFromInitialOffset() {
    return this.internalMonitor.getDifferenceFromInitialOffset();
  };

  return TargetMonitor;
})();

function createTargetMonitor(manager) {
  return new TargetMonitor(manager);
}

module.exports = exports['default'];