'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

exports['default'] = decorateHandler;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _disposables = require('disposables');

var _utilsShallowEqual = require('./utils/shallowEqual');

var _utilsShallowEqual2 = _interopRequireDefault(_utilsShallowEqual);

var _utilsShallowEqualScalar = require('./utils/shallowEqualScalar');

var _utilsShallowEqualScalar2 = _interopRequireDefault(_utilsShallowEqualScalar);

var _lodashLangIsPlainObject = require('lodash/lang/isPlainObject');

var _lodashLangIsPlainObject2 = _interopRequireDefault(_lodashLangIsPlainObject);

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _bindConnector2 = require('./bindConnector');

var _bindConnector3 = _interopRequireDefault(_bindConnector2);

function decorateHandler(_ref) {
  var DecoratedComponent = _ref.DecoratedComponent;
  var createHandler = _ref.createHandler;
  var createMonitor = _ref.createMonitor;
  var createConnector = _ref.createConnector;
  var registerHandler = _ref.registerHandler;
  var containerDisplayName = _ref.containerDisplayName;
  var getType = _ref.getType;
  var collect = _ref.collect;
  var options = _ref.options;
  var _options$arePropsEqual = options.arePropsEqual;
  var arePropsEqual = _options$arePropsEqual === undefined ? _utilsShallowEqualScalar2['default'] : _options$arePropsEqual;

  var displayName = DecoratedComponent.displayName || DecoratedComponent.name || 'Component';

  return (function (_Component) {
    function DragDropContainer(props, context) {
      _classCallCheck(this, DragDropContainer);

      _Component.call(this, props, context);
      this.handleChange = this.handleChange.bind(this);
      this.handleChildRef = this.handleChildRef.bind(this);

      (0, _invariant2['default'])(typeof this.context.dragDropManager === 'object', 'Could not find the drag and drop manager in the context of %s. ' + 'Make sure to wrap the top-level component of your app with DragDropContext. ' + 'Read more: http://gaearon.github.io/react-dnd/docs-troubleshooting.html#could-not-find-the-drag-and-drop-manager-in-the-context', displayName, displayName);

      this.manager = this.context.dragDropManager;
      this.handlerMonitor = createMonitor(this.manager);
      this.handler = createHandler(this.handlerMonitor);
      this.disposable = new _disposables.SerialDisposable();

      this.receiveProps(props);
      this.state = this.getCurrentState();
    }

    _inherits(DragDropContainer, _Component);

    DragDropContainer.prototype.getHandlerId = function getHandlerId() {
      return this.handlerId;
    };

    DragDropContainer.prototype.getDecoratedComponentInstance = function getDecoratedComponentInstance() {
      return this.decoratedComponentInstance;
    };

    DragDropContainer.prototype.shouldComponentUpdate = function shouldComponentUpdate(nextProps, nextState) {
      return !arePropsEqual(nextProps, this.props) || !(0, _utilsShallowEqual2['default'])(nextState, this.state);
    };

    DragDropContainer.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
      if (!arePropsEqual(nextProps, this.props)) {
        this.receiveProps(nextProps);
        this.handleChange();
      }
    };

    DragDropContainer.prototype.componentWillUnmount = function componentWillUnmount() {
      this.disposable.dispose();
    };

    DragDropContainer.prototype.receiveProps = function receiveProps(props) {
      this.handler.receiveProps(props);
      this.receiveType(getType(props));
    };

    DragDropContainer.prototype.receiveType = function receiveType(type) {
      if (type === this.currentType) {
        return;
      }

      this.currentType = type;

      var _registerHandler = registerHandler(type, this.handler, this.manager);

      var handlerId = _registerHandler.handlerId;
      var unregister = _registerHandler.unregister;

      var connector = createConnector(this.manager.getBackend());

      var _bindConnector = (0, _bindConnector3['default'])(connector, handlerId);

      var handlerConnector = _bindConnector.handlerConnector;
      var connectorDisposable = _bindConnector.disposable;

      var globalMonitor = this.manager.getMonitor();
      var unsubscribe = globalMonitor.subscribeToStateChange(this.handleChange, { handlerIds: [handlerId] });

      this.disposable.setDisposable(new _disposables.CompositeDisposable(new _disposables.Disposable(unregister), new _disposables.Disposable(unsubscribe), connectorDisposable));

      this.handlerMonitor.receiveHandlerId(handlerId);
      this.handlerConnector = handlerConnector;
      this.handlerId = handlerId;
    };

    DragDropContainer.prototype.handleChange = function handleChange() {
      var nextState = this.getCurrentState();
      if (!(0, _utilsShallowEqual2['default'])(nextState, this.state)) {
        this.setState(nextState);
      }
    };

    DragDropContainer.prototype.handleChildRef = function handleChildRef(component) {
      this.decoratedComponentInstance = component;
      this.handler.receiveComponent(component);
    };

    DragDropContainer.prototype.getCurrentState = function getCurrentState() {
      var nextState = collect(this.handlerConnector, this.handlerMonitor);
      if (process.env.NODE_ENV !== 'production') {
        (0, _invariant2['default'])((0, _lodashLangIsPlainObject2['default'])(nextState), 'Expected `collect` specified as the second argument to ' + '%s for %s to return a plain object of props to inject. ' + 'Instead, received %s.', containerDisplayName, displayName, nextState);
      }
      return nextState;
    };

    DragDropContainer.prototype.render = function render() {
      return _react2['default'].createElement(DecoratedComponent, _extends({}, this.props, this.state, {
        ref: this.handleChildRef }));
    };

    _createClass(DragDropContainer, null, [{
      key: 'DecoratedComponent',
      value: DecoratedComponent,
      enumerable: true
    }, {
      key: 'displayName',
      value: '' + containerDisplayName + '(' + displayName + ')',
      enumerable: true
    }, {
      key: 'contextTypes',
      value: {
        dragDropManager: _react.PropTypes.object.isRequired
      },
      enumerable: true
    }]);

    return DragDropContainer;
  })(_react.Component);
}

module.exports = exports['default'];