"use strict";

var _recast = require("recast");

var _recast2 = _interopRequireDefault(_recast);

var _parse = require("../../tests/parse");

var _parse2 = _interopRequireDefault(_parse);

var _ = require("../");

var _2 = _interopRequireDefault(_);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var n = _recast2.default.types.namedTypes;

describe("annotationResolver", function () {
  function parseSource(source) {
    return (0, _2.default)((0, _parse2.default)(source, _recast2.default), _recast2.default);
  }

  describe("annotated export", function () {
    test("finds annoted export Stateful", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = React.createClass({});\n\n        /**\n         * @component\n         */\n        export default Component;\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(1);
      expect(result[0] instanceof _recast2.default.types.NodePath).toBe(true);
      expect(result[0].node.callee.object.name).toBe("React");
    });
    test("finds annoted export Stateless", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = () => <div />;\n\n        /**\n         * @component\n         */\n        export default Component;\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(1);
      expect(result[0] instanceof _recast2.default.types.NodePath).toBe(true);
      expect(n.ArrowFunctionExpression.check(result[0].node)).toBe(true);
    });
    test("finds annotated export Stateful wrapped in HOC", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = React.createClass({});\n\n        /**\n         * @component\n         */\n        export default connect(mapStateToProps, Component);\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(1);
      expect(result[0] instanceof _recast2.default.types.NodePath).toBe(true);
      expect(result[0].node.callee.object.name).toBe("React");
    });
    test("finds annotated export Stateless wrapped in HOC", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = () => <div />;\n\n        /**\n         * @component\n         */\n        export default connect(mapStateToProps, Component);\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(1);
      expect(result[0] instanceof _recast2.default.types.NodePath).toBe(true);
      expect(n.ArrowFunctionExpression.check(result[0].node)).toBe(true);
    });
    test("Does not find if not annotated Stateless", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = () => <div />;\n\n        export default Component;\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(0);
    });
    test("does not find if not annoted export Stateful", function () {
      var source = "\n        import React from \"react\";\n\n        const Component = React.createClass({});\n\n        export default Component;\n      ";

      var result = parseSource(source);
      expect(Array.isArray(result)).toBe(true);
      expect(result.length).toBe(0);
    });
  });
});