"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (ast, recast) {
  var components = [];
  var types = recast.types.namedTypes;

  var exportTagged = function exportTagged(path) {
    /**
     * If an export doesn't have leading comments, we can simply continue
     */
    var leadingComments = path.value.leadingComments;
    if (!leadingComments) {
      return false;
    }

    // Search for the @component tag in any export.
    var isTagged = leadingComments.reduce(function (acc, comment) {
      return acc === true || comment.value.indexOf("@component") !== -1;
    }, []);

    if (!isTagged) {
      return false;
    }

    var definitions = _reactDocgen.utils.resolveExportDeclaration(path, types);

    definitions.forEach(function (definition) {
      if (definition && components.indexOf(definition) === -1) {
        components.push(_reactDocgen.utils.resolveToValue((0, _resolveHOC2.default)(definition)));
      }
    });

    return false;
  };

  recast.visit(ast, {
    visitFunctionDeclaration: false,
    visitFunctionExpression: false,
    visitClassDeclaration: false,
    visitClassExpression: false,
    visitIfStatement: false,
    visitWithStatement: false,
    visitSwitchStatement: false,
    visitCatchCause: false,
    visitWhileStatement: false,
    visitDoWhileStatement: false,
    visitForStatement: false,
    visitForInStatement: false,

    visitExportDeclaration: exportTagged,
    visitExportNamedDeclaration: exportTagged,
    visitExportDefaultDeclaration: exportTagged
  });

  return components;
};

var _reactDocgen = require("react-docgen");

var _resolveHOC = require("react-docgen/dist/utils/resolveHOC");

var _resolveHOC2 = _interopRequireDefault(_resolveHOC);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }