'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDisplayNameHandler = createDisplayNameHandler;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _reactDocgen = require('react-docgen');

var _astTypes = require('ast-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getMemberValuePath = _reactDocgen.utils.getMemberValuePath,
    getNameOrValue = _reactDocgen.utils.getNameOrValue,
    isExportsOrModuleAssignment = _reactDocgen.utils.isExportsOrModuleAssignment;


var DEFAULT_NAME = 'UnknownComponent';

function getNameFromPath(path) {
  var node = path.node;
  switch (node.type) {
    case _astTypes.namedTypes.Identifier.name:
    case _astTypes.namedTypes.Literal.name:
      return getNameOrValue(path);
    case _astTypes.namedTypes.MemberExpression.name:
      return _reactDocgen.utils.getMembers(path).reduce(function (name, _ref) {
        var path = _ref.path,
            computed = _ref.computed;
        return computed && getNameFromPath(path) ? name : `${name}.${getNameFromPath(path) || ''}`;
      }, getNameFromPath(path.get('object')));
    default:
      return null;
  }
}

function getStaticDisplayName(path) {
  var displayName = null;
  var staticMember = getMemberValuePath(path, 'displayName');
  if (staticMember && _astTypes.namedTypes.Literal.check(staticMember.node)) {
    displayName = getNameFromPath(staticMember);
  }

  return displayName || null;
}

function getNodeIdentifier(path) {
  var displayName = null;
  if (_astTypes.namedTypes.FunctionExpression.check(path.node) || _astTypes.namedTypes.FunctionDeclaration.check(path.node) || _astTypes.namedTypes.ClassExpression.check(path.node) || _astTypes.namedTypes.ClassDeclaration.check(path.node)) {
    displayName = getNameFromPath(path.get('id'));
  }

  return displayName || null;
}

function getVariableIdentifier(path) {
  var displayName = null;
  var searchPath = path;

  while (searchPath !== null) {
    if (_astTypes.namedTypes.VariableDeclarator.check(searchPath.node)) {
      displayName = getNameFromPath(searchPath.get('id'));
      break;
    }
    if (_astTypes.namedTypes.AssignmentExpression.check(searchPath.node) && !isExportsOrModuleAssignment(searchPath)) {
      displayName = getNameFromPath(searchPath.get('left'));
      break;
    }
    searchPath = searchPath.parentPath;
  }

  return displayName || null;
}

function getNameFromFilePath() {
  var filePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  var displayName = null;

  var filename = _path2.default.basename(filePath, _path2.default.extname(filePath));
  if (filename === 'index') {
    var parts = _path2.default.dirname(filePath).split(_path2.default.sep);
    displayName = parts[parts.length - 1];
  } else {
    displayName = filename;
  }

  return displayName.charAt(0).toUpperCase().concat(displayName.slice(1)).replace(/-([a-z])/, function (_, match) {
    return match.toUpperCase();
  });
}

function createDisplayNameHandler(filePath) {
  return function displayNameHandler(documentation, path) {
    var displayName = [getStaticDisplayName, getNodeIdentifier, getVariableIdentifier].reduce(function (name, getDisplayName) {
      return name || getDisplayName(path);
    }, '');

    if (!displayName) {
      displayName = getNameFromFilePath(filePath);
    }

    documentation.set('displayName', displayName || DEFAULT_NAME);
  };
}

exports.default = createDisplayNameHandler('');