"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

/*
 *  Copyright (c) 2015, Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 *
 *  
 *
 */
class Documentation {
  constructor() {
    this._props = new Map();
    this._context = new Map();
    this._childContext = new Map();
    this._composes = new Set();
    this._data = new Map();
  }

  addComposes(moduleName) {
    this._composes.add(moduleName);
  }

  set(key, value) {
    this._data.set(key, value);
  }

  get(key) {
    return this._data.get(key);
  }

  getPropDescriptor(propName) {
    let propDescriptor = this._props.get(propName);

    if (!propDescriptor) {
      this._props.set(propName, propDescriptor = {});
    }

    return propDescriptor;
  }

  getContextDescriptor(propName) {
    let propDescriptor = this._context.get(propName);

    if (!propDescriptor) {
      this._context.set(propName, propDescriptor = {});
    }

    return propDescriptor;
  }

  getChildContextDescriptor(propName) {
    let propDescriptor = this._childContext.get(propName);

    if (!propDescriptor) {
      this._childContext.set(propName, propDescriptor = {});
    }

    return propDescriptor;
  }

  toObject() {
    const obj = {};
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = this._data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const _step$value = (0, _slicedToArray2.default)(_step.value, 2),
              key = _step$value[0],
              value = _step$value[1];

        obj[key] = value;
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    if (this._props.size > 0) {
      obj.props = {};
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this._props[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          const _step2$value = (0, _slicedToArray2.default)(_step2.value, 2),
                propName = _step2$value[0],
                propDescriptor = _step2$value[1];

          if (Object.keys(propDescriptor).length > 0) {
            obj.props[propName] = propDescriptor;
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }

    if (this._context.size > 0) {
      obj.context = {};
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = this._context[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          const _step3$value = (0, _slicedToArray2.default)(_step3.value, 2),
                contextName = _step3$value[0],
                contextDescriptor = _step3$value[1];

          if (Object.keys(contextDescriptor).length > 0) {
            obj.context[contextName] = contextDescriptor;
          }
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }

    if (this._childContext.size > 0) {
      obj.childContext = {};
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = this._childContext[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          const _step4$value = (0, _slicedToArray2.default)(_step4.value, 2),
                childContextName = _step4$value[0],
                childContextDescriptor = _step4$value[1];

          obj.childContext[childContextName] = childContextDescriptor;
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return != null) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }

    if (this._composes.size > 0) {
      obj.composes = Array.from(this._composes);
    }

    return obj;
  }

}

module.exports = Documentation;