"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = componentMethodsJsDocHandler;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));

var _parseJsDoc = _interopRequireDefault(require("../utils/parseJsDoc"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
// Merges two objects ignoring null/undefined.
function merge(obj1, obj2) {
  if (obj1 == null && obj2 == null) {
    return null;
  }

  const merged = (0, _objectSpread2.default)({}, obj1);

  for (const prop in obj2) {
    if (obj2[prop] != null) {
      merged[prop] = obj2[prop];
    }
  }

  return merged;
}
/**
 * Extract info from the methods jsdoc blocks. Must be run after
 * flowComponentMethodsHandler.
 */


function componentMethodsJsDocHandler(documentation) {
  let methods = documentation.get('methods');

  if (!methods) {
    return;
  }

  methods = methods.map(method => {
    if (!method.docblock) {
      return method;
    }

    const jsDoc = (0, _parseJsDoc.default)(method.docblock);
    const returns = merge(jsDoc.returns, method.returns);
    const params = method.params.map(param => {
      const jsDocParam = jsDoc.params.find(p => p.name === param.name);
      return merge(jsDocParam, param);
    });
    return (0, _objectSpread2.default)({}, method, {
      description: jsDoc.description || null,
      returns,
      params
    });
  });
  documentation.set('methods', methods);
}