"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flowTypeHandler;

var _recast = _interopRequireDefault(require("recast"));

var _getFlowType = _interopRequireDefault(require("../utils/getFlowType"));

var _getPropertyName = _interopRequireDefault(require("../utils/getPropertyName"));

var _getFlowTypeFromReactComponent = _interopRequireWildcard(require("../utils/getFlowTypeFromReactComponent"));

var _resolveToValue = _interopRequireDefault(require("../utils/resolveToValue"));

var _setPropDescription = _interopRequireDefault(require("../utils/setPropDescription"));

var _flowUtilityTypes = require("../utils/flowUtilityTypes");

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;

function setPropDescriptor(documentation, path) {
  if (types.ObjectTypeSpreadProperty.check(path.node)) {
    let argument = path.get('argument');

    while ((0, _flowUtilityTypes.isSupportedUtilityType)(argument)) {
      argument = (0, _flowUtilityTypes.unwrapUtilityType)(argument);
    }

    if (types.ObjectTypeAnnotation.check(argument.node)) {
      (0, _getFlowTypeFromReactComponent.applyToFlowTypeProperties)(argument, propertyPath => {
        setPropDescriptor(documentation, propertyPath);
      });
      return;
    }

    const name = argument.get('id').get('name');
    const resolvedPath = (0, _resolveToValue.default)(name);

    if (resolvedPath && types.TypeAlias.check(resolvedPath.node)) {
      const right = resolvedPath.get('right');
      (0, _getFlowTypeFromReactComponent.applyToFlowTypeProperties)(right, propertyPath => {
        setPropDescriptor(documentation, propertyPath);
      });
    } else {
      documentation.addComposes(name.node.name);
    }
  } else if (types.ObjectTypeProperty.check(path.node)) {
    const type = (0, _getFlowType.default)(path.get('value'));
    const propDescriptor = documentation.getPropDescriptor((0, _getPropertyName.default)(path));
    propDescriptor.required = !path.node.optional;
    propDescriptor.flowType = type; // We are doing this here instead of in a different handler
    // to not need to duplicate the logic for checking for
    // imported types that are spread in to props.

    (0, _setPropDescription.default)(documentation, path);
  }
}
/**
 * This handler tries to find flow Type annotated react components and extract
 * its types to the documentation. It also extracts docblock comments which are
 * inlined in the type definition.
 */


function flowTypeHandler(documentation, path) {
  const flowTypesPath = (0, _getFlowTypeFromReactComponent.default)(path);

  if (!flowTypesPath) {
    return;
  }

  (0, _getFlowTypeFromReactComponent.applyToFlowTypeProperties)(flowTypesPath, propertyPath => {
    setPropDescriptor(documentation, propertyPath);
  });
}