"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = propTypeCompositionHandler;

var _getMemberValuePath = _interopRequireDefault(require("../utils/getMemberValuePath"));

var _recast = _interopRequireDefault(require("recast"));

var _resolveToModule = _interopRequireDefault(require("../utils/resolveToModule"));

var _resolveToValue = _interopRequireDefault(require("../utils/resolveToValue"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * It resolves the path to its module name and adds it to the "composes" entry
 * in the documentation.
 */

function amendComposes(documentation, path) {
  const moduleName = (0, _resolveToModule.default)(path);

  if (moduleName) {
    documentation.addComposes(moduleName);
  }
}

function processObjectExpression(documentation, path) {
  path.get('properties').each(function (propertyPath) {
    switch (propertyPath.node.type) {
      case types.SpreadElement.name:
        amendComposes(documentation, (0, _resolveToValue.default)(propertyPath.get('argument')));
        break;
    }
  });
}

function propTypeCompositionHandler(documentation, path) {
  let propTypesPath = (0, _getMemberValuePath.default)(path, 'propTypes');

  if (!propTypesPath) {
    return;
  }

  propTypesPath = (0, _resolveToValue.default)(propTypesPath);

  if (!propTypesPath) {
    return;
  }

  switch (propTypesPath.node.type) {
    case types.ObjectExpression.name:
      processObjectExpression(documentation, propTypesPath);
      break;

    default:
      amendComposes(documentation, propTypesPath);
      break;
  }
}