"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = findAllReactCreateClassCalls;

var _isReactComponentClass = _interopRequireDefault(require("../utils/isReactComponentClass"));

var _isReactCreateClassCall = _interopRequireDefault(require("../utils/isReactCreateClassCall"));

var _isStatelessComponent = _interopRequireDefault(require("../utils/isStatelessComponent"));

var _normalizeClassDefinition = _interopRequireDefault(require("../utils/normalizeClassDefinition"));

var _resolveToValue = _interopRequireDefault(require("../utils/resolveToValue"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */

/**
 * Given an AST, this function tries to find all object expressions that are
 * passed to `React.createClass` calls, by resolving all references properly.
 */
function findAllReactCreateClassCalls(ast, recast) {
  const types = recast.types.namedTypes;
  const definitions = [];

  function classVisitor(path) {
    if ((0, _isReactComponentClass.default)(path)) {
      (0, _normalizeClassDefinition.default)(path);
      definitions.push(path);
    }

    return false;
  }

  function statelessVisitor(path) {
    if ((0, _isStatelessComponent.default)(path)) {
      definitions.push(path);
    }

    return false;
  }

  recast.visit(ast, {
    visitFunctionDeclaration: statelessVisitor,
    visitFunctionExpression: statelessVisitor,
    visitArrowFunctionExpression: statelessVisitor,
    visitClassExpression: classVisitor,
    visitClassDeclaration: classVisitor,
    visitCallExpression: function visitCallExpression(path) {
      if (!(0, _isReactCreateClassCall.default)(path)) {
        return false;
      }

      const resolvedPath = (0, _resolveToValue.default)(path.get('arguments', 0));

      if (types.ObjectExpression.check(resolvedPath.node)) {
        definitions.push(resolvedPath);
      }

      return false;
    }
  });
  return definitions;
}