"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getClassMemberValuePath;

var _getNameOrValue = _interopRequireDefault(require("./getNameOrValue"));

var _recast = _interopRequireDefault(require("recast"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;

function getClassMemberValuePath(classDefinition, memberName) {
  // Fortunately it seems like that all members of a class body, be it
  // ClassProperty or MethodDefinition, have the same structure: They have a
  // "key" and a "value"
  return classDefinition.get('body', 'body').filter(memberPath => (!memberPath.node.computed || types.Literal.check(memberPath.node.key)) && (0, _getNameOrValue.default)(memberPath.get('key')) === memberName && memberPath.node.kind !== 'set').map(memberPath => memberPath.get('value'))[0];
}