"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getMemberValuePath;

var _getClassMemberValuePath = _interopRequireDefault(require("./getClassMemberValuePath"));

var _getMemberExpressionValuePath = _interopRequireDefault(require("./getMemberExpressionValuePath"));

var _getPropertyValuePath = _interopRequireDefault(require("./getPropertyValuePath"));

var _resolveFunctionDefinitionToReturnValue = _interopRequireDefault(require("../utils/resolveFunctionDefinitionToReturnValue"));

var _recast = _interopRequireDefault(require("recast"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
const SYNONYMS = {
  getDefaultProps: 'defaultProps',
  defaultProps: 'getDefaultProps'
};
const POSTPROCESS_MEMBERS = {
  propTypes: path => types.Function.check(path.node) ? (0, _resolveFunctionDefinitionToReturnValue.default)(path) : path
};
const LOOKUP_METHOD = {
  [types.ArrowFunctionExpression.name]: _getMemberExpressionValuePath.default,
  [types.FunctionExpression.name]: _getMemberExpressionValuePath.default,
  [types.FunctionDeclaration.name]: _getMemberExpressionValuePath.default,
  [types.VariableDeclaration.name]: _getMemberExpressionValuePath.default,
  [types.ObjectExpression.name]: _getPropertyValuePath.default,
  [types.ClassDeclaration.name]: _getClassMemberValuePath.default,
  [types.ClassExpression.name]: _getClassMemberValuePath.default
};

function isSupportedDefinitionType({
  node
}) {
  return types.ObjectExpression.check(node) || types.ClassDeclaration.check(node) || types.ClassExpression.check(node) ||
  /**
   * Adds support for libraries such as
   * [styled components]{@link https://github.com/styled-components} that use
   * TaggedTemplateExpression's to generate components.
   *
   * While react-docgen's built-in resolvers do not support resolving
   * TaggedTemplateExpression definitiona, third-party resolvers (such as
   * https://github.com/Jmeyering/react-docgen-annotation-resolver) could be
   * used to add these definitions.
   */
  types.TaggedTemplateExpression.check(node) || // potential stateless function component
  types.VariableDeclaration.check(node) || types.ArrowFunctionExpression.check(node) || types.FunctionDeclaration.check(node) || types.FunctionExpression.check(node);
}
/**
 * This is a helper method for handlers to make it easier to work either with
 * an ObjectExpression from `React.createClass` class or with a class
 * definition.
 *
 * Given a path and a name, this function will either return the path of the
 * property value if the path is an ObjectExpression, or the value of the
 * ClassProperty/MethodDefinition if it is a class definition (declaration or
 * expression).
 *
 * It also normalizes the names so that e.g. `defaultProps` and
 * `getDefaultProps` can be used interchangeably.
 */


function getMemberValuePath(componentDefinition, memberName) {
  if (!isSupportedDefinitionType(componentDefinition)) {
    throw new TypeError('Got unsupported definition type. Definition must be one of ' + 'ObjectExpression, ClassDeclaration, ClassExpression,' + 'VariableDeclaration, ArrowFunctionExpression, FunctionExpression, ' + 'TaggedTemplateExpression or FunctionDeclaration. Got "' + componentDefinition.node.type + '"' + 'instead.');
  }

  const lookupMethod = LOOKUP_METHOD[componentDefinition.node.type] || _getMemberExpressionValuePath.default;
  let result = lookupMethod(componentDefinition, memberName);

  if (!result && SYNONYMS[memberName]) {
    result = lookupMethod(componentDefinition, SYNONYMS[memberName]);
  }

  if (result && POSTPROCESS_MEMBERS[memberName]) {
    result = POSTPROCESS_MEMBERS[memberName](result);
  }

  return result;
}