"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getNameOrValue;

var _recast = _interopRequireDefault(require("recast"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * If node is an Identifier, it returns its name. If it is a literal, it returns
 * its value.
 */

function getNameOrValue(path, raw) {
  const node = path.node;

  switch (node.type) {
    case types.Identifier.name:
      return node.name;

    case types.Literal.name:
      return raw ? node.raw : node.value;

    default:
      throw new TypeError('Argument must be an Identifier or a Literal');
  }
}