"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getParameterName;

var _recast = _interopRequireDefault(require("recast"));

var _printValue = _interopRequireDefault(require("./printValue"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
const types = _recast.default.types.namedTypes;

function getParameterName(parameterPath) {
  switch (parameterPath.node.type) {
    case types.Identifier.name:
      return parameterPath.node.name;

    case types.AssignmentPattern.name:
      return getParameterName(parameterPath.get('left'));

    case types.ObjectPattern.name:
    case types.ArrayPattern.name:
      return (0, _printValue.default)(parameterPath);

    case types.RestElement.name:
      return '...' + getParameterName(parameterPath.get('argument'));

    default:
      throw new TypeError('Parameter name must be an Identifier, an AssignmentPattern an ' + `ObjectPattern or a RestElement, got ${parameterPath.node.type}`);
  }
}