"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getPropertyValuePath;

var _getPropertyName = _interopRequireDefault(require("./getPropertyName"));

var _recast = _interopRequireDefault(require("recast"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * Given an ObjectExpression, this function returns the path of the value of
 * the property with name `propertyName`.
 */

function getPropertyValuePath(path, propertyName) {
  types.ObjectExpression.assert(path.node);
  return path.get('properties').filter(propertyPath => (0, _getPropertyName.default)(propertyPath) === propertyName).map(propertyPath => propertyPath.get('value'))[0];
}