"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isReactChildrenElementCall;

var _isReactModuleName = _interopRequireDefault(require("./isReactModuleName"));

var _match = _interopRequireDefault(require("./match"));

var _recast = _interopRequireDefault(require("recast"));

var _resolveToModule = _interopRequireDefault(require("./resolveToModule"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * Returns true if the expression is a function call of the form
 * `React.Children.only(...)`.
 */

function isReactChildrenElementCall(path) {
  if (types.ExpressionStatement.check(path.node)) {
    path = path.get('expression');
  }

  if (!(0, _match.default)(path.node, {
    callee: {
      property: {
        name: 'only'
      }
    }
  })) {
    return false;
  }

  const calleeObj = path.get('callee', 'object');
  const module = (0, _resolveToModule.default)(calleeObj);

  if (!(0, _match.default)(calleeObj, {
    value: {
      property: {
        name: 'Children'
      }
    }
  })) {
    return false;
  }

  return Boolean(module && (0, _isReactModuleName.default)(module));
}