"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isReactComponentClass;

var _isReactModuleName = _interopRequireDefault(require("./isReactModuleName"));

var _match = _interopRequireDefault(require("./match"));

var _recast = _interopRequireDefault(require("recast"));

var _resolveToModule = _interopRequireDefault(require("./resolveToModule"));

var _resolveToValue = _interopRequireDefault(require("./resolveToValue"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
const types = _recast.default.types.namedTypes;

function isRenderMethod(node) {
  const isProperty = node.type === 'ClassProperty';
  return (types.MethodDefinition.check(node) || isProperty) && !node.computed && !node.static && (node.kind === '' || node.kind === 'method' || isProperty) && node.key.name === 'render';
}
/**
 * Returns `true` of the path represents a class definition which either extends
 * `React.Component` or implements a `render()` method.
 */


function isReactComponentClass(path) {
  const node = path.node;

  if (!types.ClassDeclaration.check(node) && !types.ClassExpression.check(node)) {
    return false;
  } // render method


  if (node.body.body.some(isRenderMethod)) {
    return true;
  } // check for @extends React.Component in docblock


  if (path.parentPath && path.parentPath.value) {
    const classDeclaration = Array.isArray(path.parentPath.value) ? path.parentPath.value.find(function (declaration) {
      return declaration.type === 'ClassDeclaration';
    }) : path.parentPath.value;

    if (classDeclaration && classDeclaration.leadingComments && classDeclaration.leadingComments.some(function (comment) {
      return /@extends\s+React\.Component/.test(comment.value);
    })) {
      return true;
    }
  } // extends ReactComponent?


  if (!node.superClass) {
    return false;
  }

  const superClass = (0, _resolveToValue.default)(path.get('superClass'));

  if (!(0, _match.default)(superClass.node, {
    property: {
      name: 'Component'
    }
  })) {
    return false;
  }

  const module = (0, _resolveToModule.default)(superClass);
  return !!module && (0, _isReactModuleName.default)(module);
}