"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _recast = _interopRequireDefault(require("recast"));

var _getPropertyName = _interopRequireDefault(require("./getPropertyName"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
const types = _recast.default.types.namedTypes;
const componentMethods = ['componentDidMount', 'componentDidReceiveProps', 'componentDidUpdate', 'componentWillMount', 'componentWillReceiveProps', 'componentWillUnmount', 'componentWillUpdate', 'getChildContext', 'getDefaultProps', 'getInitialState', 'render', 'shouldComponentUpdate'];
/**
 * Returns if the method path is a Component method.
 */

function _default(methodPath) {
  if (!types.MethodDefinition.check(methodPath.node) && !types.Property.check(methodPath.node)) {
    return false;
  }

  const name = (0, _getPropertyName.default)(methodPath);
  return componentMethods.indexOf(name) !== -1;
}