"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isReactCreateClassCall;

var _isReactModuleName = _interopRequireDefault(require("./isReactModuleName"));

var _match = _interopRequireDefault(require("./match"));

var _recast = _interopRequireDefault(require("recast"));

var _resolveToModule = _interopRequireDefault(require("./resolveToModule"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * Returns true if the expression is a function call of the form
 * `React.createClass(...)`.
 */

function isReactCreateClassCallBuiltIn(path) {
  if (types.ExpressionStatement.check(path.node)) {
    path = path.get('expression');
  }

  if (!(0, _match.default)(path.node, {
    callee: {
      property: {
        name: 'createClass'
      }
    }
  })) {
    return false;
  }

  const module = (0, _resolveToModule.default)(path.get('callee', 'object'));
  return Boolean(module && (0, _isReactModuleName.default)(module));
}
/**
 * Returns true if the expression is a function call of the form
 * ```
 * import createReactClass from 'create-react-class';
 * createReactClass(...);
 * ```
 */


function isReactCreateClassCallModular(path) {
  if (types.ExpressionStatement.check(path.node)) {
    path = path.get('expression');
  }

  if (!(0, _match.default)(path.node, {
    type: 'CallExpression'
  })) {
    return false;
  }

  const module = (0, _resolveToModule.default)(path);
  return Boolean(module && module === 'create-react-class');
}
/**
 * Returns true if the expression is a function call of the form
 * `React.createClass(...)` or
 * ```
 * import createReactClass from 'create-react-class';
 * createReactClass(...);
 * ```
 */


function isReactCreateClassCall(path) {
  return isReactCreateClassCallBuiltIn(path) || isReactCreateClassCallModular(path);
}