"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveExportDeclaration;

var _recast = _interopRequireDefault(require("recast"));

var _resolveToValue = _interopRequireDefault(require("./resolveToValue"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
const _types = _recast.default.types.namedTypes;

function resolveExportDeclaration(path, types = _types) {
  const definitions = [];

  if (path.node.default) {
    definitions.push(path.get('declaration'));
  } else if (path.node.declaration) {
    if (types.VariableDeclaration.check(path.node.declaration)) {
      path.get('declaration', 'declarations').each(declarator => definitions.push(declarator));
    } else {
      definitions.push(path.get('declaration'));
    }
  } else if (path.node.specifiers) {
    path.get('specifiers').each(specifier => definitions.push(specifier.node.id ? specifier.get('id') : specifier.get('local')));
  }

  return definitions.map(definition => (0, _resolveToValue.default)(definition));
}