"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveFunctionDefinitionToReturnValue;

var _resolveToValue = _interopRequireDefault(require("./resolveToValue"));

var _traverse = require("./traverse");

/*
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */
function resolveFunctionDefinitionToReturnValue(path) {
  let returnPath = null;
  (0, _traverse.traverseShallow)(path.get('body'), {
    visitFunction: () => false,
    visitReturnStatement: nodePath => {
      returnPath = (0, _resolveToValue.default)(nodePath.get('argument'));
      return false;
    }
  });
  return returnPath;
}