"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveGenericTypeAnnotation;

var _isUnreachableFlowType = _interopRequireDefault(require("../utils/isUnreachableFlowType"));

var _recast = _interopRequireDefault(require("recast"));

var _resolveToValue = _interopRequireDefault(require("../utils/resolveToValue"));

var _flowUtilityTypes = require("./flowUtilityTypes");

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const types = _recast.default.types.namedTypes;
/**
 * Given an React component (stateless or class) tries to find the
 * flow type for the props. If not found or not one of the supported
 * component types returns null.
 */

function resolveGenericTypeAnnotation(path) {
  // If the node doesn't have types or properties, try to get the type.
  let typePath;

  if (path && (0, _flowUtilityTypes.isSupportedUtilityType)(path)) {
    typePath = (0, _flowUtilityTypes.unwrapUtilityType)(path);
  } else if (path && types.GenericTypeAnnotation.check(path.node)) {
    typePath = (0, _resolveToValue.default)(path.get('id'));

    if ((0, _isUnreachableFlowType.default)(typePath)) {
      return;
    }

    typePath = typePath.get('right');
  }

  return typePath;
}