"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveHOC;

var _recast = _interopRequireDefault(require("recast"));

var _isReactCreateClassCall = _interopRequireDefault(require("./isReactCreateClassCall"));

/*
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 *
 */
const _recast$types = _recast.default.types,
      NodePath = _recast$types.NodePath,
      types = _recast$types.namedTypes;
/**
 * If the path is a call expression, it recursively resolves to the
 * rightmost argument, stopping if it finds a React.createClass call expression
 *
 * Else the path itself is returned.
 */

function resolveHOC(path) {
  const node = path.node;

  if (types.CallExpression.check(node) && !(0, _isReactCreateClassCall.default)(path)) {
    if (node.arguments.length) {
      return resolveHOC(path.get('arguments', node.arguments.length - 1));
    }
  }

  return path;
}