'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _map = require('babel-runtime/core-js/map');

var _map2 = _interopRequireDefault(_map);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactMotion = require('react-motion');

var _immutabilityHelper = require('immutability-helper');

var _immutabilityHelper2 = _interopRequireDefault(_immutabilityHelper);

var _reactSaveRefs = require('react-save-refs');

var _reactSaveRefs2 = _interopRequireDefault(_reactSaveRefs);

var _DragHandle = require('./DragHandle');

var _DragHandle2 = _interopRequireDefault(_DragHandle);

var _OnUpdate = require('./OnUpdate');

var _OnUpdate2 = _interopRequireDefault(_OnUpdate);

var _MoveContainer = require('./MoveContainer');

var _MoveContainer2 = _interopRequireDefault(_MoveContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT_HEIGHT = { natural: 200, drag: 30 };
/* eslint react/prop-types: "error" */

function getScrollSpeed(distance, speed, size) {
  // If distance is zero, then the result is the max speed. Otherwise,
  // the result tapers toward zero as it gets closer to the opposite
  // edge of the region.
  return Math.round(speed - speed / size * distance);
}

var DraggableList = function (_React$Component) {
  (0, _inherits3.default)(DraggableList, _React$Component);

  function DraggableList(props) {
    (0, _classCallCheck3.default)(this, DraggableList);

    var _this = (0, _possibleConstructorReturn3.default)(this, (DraggableList.__proto__ || (0, _getPrototypeOf2.default)(DraggableList)).call(this, props));

    _this._itemRefs = new _map2.default();
    _this._heights = new _map2.default();

    _this._handleTouchMove = function (e) {
      e.preventDefault();
      _this._handleMouseMove(e.touches[0]);
    };

    _this._handleMouseMove = function (_ref) {
      var pageY = _ref.pageY,
          clientY = _ref.clientY;
      var _this$props = _this.props,
          padding = _this$props.padding,
          autoScrollMaxSpeed = _this$props.autoScrollMaxSpeed,
          autoScrollRegionSize = _this$props.autoScrollRegionSize;
      var _this$state = _this.state,
          list = _this$state.list,
          dragging = _this$state.dragging,
          lastDrag = _this$state.lastDrag;

      if (!dragging || !lastDrag) return;

      var containerEl = _this._getContainer();
      var dragIndex = _this._getDragIndex();
      var naturalPosition = _this._getDistanceDuringDrag(lastDrag, dragIndex);

      clearInterval(_this._autoScrollerTimer);

      // If the user has the mouse near the top or bottom of the container and
      // not at the end of the list, then autoscroll.
      if (dragIndex !== 0 && dragIndex !== list.length - 1) {
        var scrollSpeed = 0;

        var containerRect = containerEl && containerEl !== document.body && containerEl.getBoundingClientRect ? containerEl.getBoundingClientRect() : { top: 0, bottom: Infinity };

        // Get the lowest of the screen top and the container top.
        var top = Math.max(0, containerRect.top);

        var distanceFromTop = clientY - top;
        if (distanceFromTop > 0 && distanceFromTop < autoScrollRegionSize) {
          scrollSpeed = -1 * getScrollSpeed(distanceFromTop, autoScrollMaxSpeed, autoScrollRegionSize);
        } else {
          // Get the lowest of the screen bottom and the container bottom.
          var bottom = Math.min(window.innerHeight, containerRect.bottom);
          var distanceFromBottom = bottom - clientY;
          if (distanceFromBottom > 0 && distanceFromBottom < autoScrollRegionSize) {
            scrollSpeed = getScrollSpeed(distanceFromBottom, autoScrollMaxSpeed, autoScrollRegionSize);
          }
        }

        if (scrollSpeed !== 0) {
          _this._scrollContainer(scrollSpeed);
          _this._autoScrollerTimer = setTimeout(function () {
            _this._handleMouseMove({
              pageY: pageY + (containerEl === document.body ? scrollSpeed : 0),
              clientY: clientY
            });
          }, 16);
        }
      }

      var containerScroll = !containerEl || containerEl === document.body ? 0 : containerEl.scrollTop;
      var mouseY = pageY - lastDrag.mouseOffset + containerScroll;

      var movementFromNatural = mouseY - naturalPosition;
      // 1 down, -1 up, 0 neither
      var direction = movementFromNatural > 0 ? 1 : movementFromNatural < 0 ? -1 : 0;
      var newIndex = dragIndex;
      if (direction !== 0) {
        var keyFn = _this._getKeyFn();
        var reach = Math.abs(movementFromNatural);
        for (var i = dragIndex + direction; i < list.length && i >= 0; i += direction) {
          var iDragHeight = (_this._heights.get(keyFn(list[i])) || DEFAULT_HEIGHT).drag;
          if (reach < iDragHeight / 2 + padding) break;
          reach -= iDragHeight + padding;
          newIndex = i;
        }
      }

      var newList = list;
      if (newIndex !== dragIndex) {
        newList = (0, _immutabilityHelper2.default)(list, {
          $splice: [[dragIndex, 1], [newIndex, 0, list[dragIndex]]]
        });
      }

      _this.setState({ lastDrag: (0, _extends3.default)({}, lastDrag, { mouseY: mouseY }), list: newList });
    };

    _this._handleMouseUp = function () {
      clearInterval(_this._autoScrollerTimer);
      window.removeEventListener('mouseup', _this._handleMouseUp);
      window.removeEventListener('touchend', _this._handleMouseUp);
      window.removeEventListener('touchmove', _this._handleTouchMove);
      window.removeEventListener('mousemove', _this._handleMouseMove);

      if (document.documentElement) document.documentElement.style.cursor = '';
      _this._lastScrollDelta = 0;

      var onMoveEnd = _this.props.onMoveEnd;
      var _this$state2 = _this.state,
          dragging = _this$state2.dragging,
          lastDrag = _this$state2.lastDrag,
          list = _this$state2.list;

      if (dragging && lastDrag && onMoveEnd) {
        var dragIndex = _this._getDragIndex();
        if (lastDrag.startIndex !== dragIndex) {
          onMoveEnd(list, list[dragIndex], lastDrag.startIndex, dragIndex);
        }
      }
      _this.setState({ dragging: false });
    };

    _this._lastScrollDelta = 0;

    _this.state = {
      list: props.list,
      useAbsolutePositioning: false,
      dragging: false,
      lastDrag: null
    };
    return _this;
  }

  (0, _createClass3.default)(DraggableList, [{
    key: 'getItemInstance',
    value: function getItemInstance(key) {
      var ref = this._itemRefs.get(key);
      if (!ref) throw new Error('key not found');
      return ref.getTemplate();
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(newProps) {
      var _state = this.state,
          dragging = _state.dragging,
          lastDrag = _state.lastDrag;
      var list = newProps.list;


      check: if (lastDrag) {
        var newDragIndex = void 0;
        try {
          newDragIndex = this._getDragIndex(list);
        } catch (err) {
          dragging = false;
          lastDrag = null;
          break check;
        }

        if (dragging) {
          var currentDragIndex = this._getDragIndex();
          if (currentDragIndex !== newDragIndex) {
            // Let's change the list so that the new drag index will be the same as
            // the current so that the dragged item doesn't jump on the screen.
            list = (0, _immutabilityHelper2.default)(list, {
              $splice: [[newDragIndex, 1], [currentDragIndex, 0, list[newDragIndex]]]
            });
          }
        }
      }
      this.setState({ dragging: dragging, lastDrag: lastDrag, list: list });
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._handleMouseUp();
    }
  }, {
    key: '_handleTouchStart',
    value: function _handleTouchStart(itemKey, pressY, e) {
      event.stopPropagation();
      this._handleStartDrag(itemKey, pressY, e.touches[0].pageY);
    }
  }, {
    key: '_handleMouseDown',
    value: function _handleMouseDown(itemKey, pressY, event) {
      event.preventDefault();
      this._handleStartDrag(itemKey, pressY, event.pageY);
    }
  }, {
    key: '_handleStartDrag',
    value: function _handleStartDrag(itemKey, pressY, pageY) {
      var _this2 = this;

      if (document.documentElement) document.documentElement.style.cursor = 'move';
      window.addEventListener('mouseup', this._handleMouseUp);
      window.addEventListener('touchend', this._handleMouseUp);
      window.addEventListener('touchmove', this._handleTouchMove);
      window.addEventListener('mousemove', this._handleMouseMove);

      // If an element has focus while we drag around the parent, some browsers
      // try to scroll the parent element to keep the focused element in view.
      // Stop that.
      {
        var listEl = (0, _reactDom.findDOMNode)(this);
        if (!(listEl instanceof HTMLElement)) throw new Error('Should not happen');
        if (listEl.contains && document.activeElement && listEl.contains(document.activeElement)) {
          document.activeElement.blur();
        }
      }

      var keyFn = this._getKeyFn();

      if (this._heights.size === 0) {
        this._heights = new _map2.default(this.state.list.map(function (item) {
          var key = keyFn(item);
          var containerRef = _this2._itemRefs.get(key);
          var ref = containerRef ? containerRef.getTemplate() : null;
          var refEl = ref ? (0, _reactDom.findDOMNode)(ref) : null;
          var natural = refEl instanceof HTMLElement ? refEl.offsetHeight : DEFAULT_HEIGHT.natural;
          var drag = ref && typeof ref.getDragHeight === 'function' && ref.getDragHeight() || natural;
          return [key, { natural: natural, drag: drag }];
        }));
      }

      var itemIndex = this.state.list.map(keyFn).indexOf(itemKey);

      var startY = pressY == null ? this._getDistance(0, itemIndex, false) : pressY;

      var containerEl = this._getContainer();
      var containerScroll = !containerEl || containerEl === document.body ? 0 : containerEl.scrollTop;

      // Need to re-render once before we start dragging so that the `y` values
      // are set using the correct _heights and then can animate from there.
      this.forceUpdate(function () {
        _this2.setState({
          useAbsolutePositioning: true,
          dragging: true,
          lastDrag: {
            itemKey: itemKey,
            startIndex: itemIndex,
            startListKeys: _this2.state.list.map(keyFn),
            startY: startY,
            mouseY: startY,
            mouseOffset: pageY - startY + containerScroll
          }
        });
      });
    }
  }, {
    key: '_scrollContainer',
    value: function _scrollContainer(delta) {
      var containerEl = this._getContainer();
      if (!containerEl) return;
      if (window.scrollBy && containerEl === document.body) {
        window.scrollBy(0, delta);
      } else {
        containerEl.scrollTop += delta;
      }
    }
  }, {
    key: '_adjustScrollAtEnd',
    value: function _adjustScrollAtEnd(delta) {
      var frameDelta = Math.round(delta - this._lastScrollDelta);
      this._scrollContainer(frameDelta);
      this._lastScrollDelta += frameDelta;
    }
  }, {
    key: '_getDragIndex',
    value: function _getDragIndex(list, lastDrag) {
      if (!list) list = this.state.list;
      if (!lastDrag) lastDrag = this.state.lastDrag;
      if (!lastDrag) {
        throw new Error('No drag happened');
      }
      var keyFn = this._getKeyFn();
      var _lastDrag = lastDrag,
          itemKey = _lastDrag.itemKey;

      for (var i = 0, len = list.length; i < len; i++) {
        if (keyFn(list[i]) === itemKey) {
          return i;
        }
      }
      throw new Error('Failed to find drag index');
    }
  }, {
    key: '_getDistance',
    value: function _getDistance(start, end, dragging) {
      if (end < start) {
        return -this._getDistance(end, start, dragging);
      }

      var padding = this.props.padding;
      var list = this.state.list;

      var keyFn = this._getKeyFn();
      var distance = 0;
      for (var i = start; i < end; i++) {
        var height = this._heights.get(keyFn(list[i])) || DEFAULT_HEIGHT;
        distance += (dragging ? height.drag : height.natural) + padding;
      }
      return distance;
    }
  }, {
    key: '_getDistanceDuringDrag',
    value: function _getDistanceDuringDrag(lastDrag, index) {
      var keyFn = this._getKeyFn();
      var list = this.state.list;


      var offset = 0;
      if (this._getDragIndex() < lastDrag.startIndex) {
        var dragItemHeight = this._heights.get(lastDrag.itemKey) || DEFAULT_HEIGHT;
        var newCenterHeight = this._heights.get(keyFn(list[lastDrag.startIndex])) || DEFAULT_HEIGHT;
        offset = dragItemHeight.drag - newCenterHeight.drag;
      }
      return lastDrag.startY + offset + this._getDistance(lastDrag.startIndex, index, true);
    }
  }, {
    key: '_getContainer',
    value: function _getContainer() {
      var container = this.props.container;

      return container ? container() : null;
    }
  }, {
    key: '_getKeyFn',
    value: function _getKeyFn() {
      var itemKey = this.props.itemKey;

      return typeof itemKey === 'function' ? itemKey : function (x) {
        return x[itemKey];
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var _props = this.props,
          springConfig = _props.springConfig,
          container = _props.container,
          padding = _props.padding,
          template = _props.template,
          unsetZIndex = _props.unsetZIndex,
          commonProps = _props.commonProps;
      var _state2 = this.state,
          list = _state2.list,
          dragging = _state2.dragging,
          lastDrag = _state2.lastDrag,
          useAbsolutePositioning = _state2.useAbsolutePositioning;


      var keyFn = this._getKeyFn();
      var anySelected = (0, _reactMotion.spring)(dragging ? 1 : 0, springConfig);

      var children = list.map(function (item, i) {
        var key = keyFn(item);
        var selectedStyle = dragging && lastDrag && lastDrag.itemKey === key ? {
          itemSelected: (0, _reactMotion.spring)(1, springConfig),
          y: lastDrag.mouseY
        } : {
          itemSelected: (0, _reactMotion.spring)(0, springConfig),
          y: (useAbsolutePositioning ? _reactMotion.spring : function (x, ignored) {
            return x;
          })(dragging && lastDrag ? _this3._getDistanceDuringDrag(lastDrag, i) : _this3._getDistance(0, i, false), springConfig)
        };
        var style = (0, _extends3.default)({
          anySelected: anySelected
        }, selectedStyle);
        var makeDragHandle = function makeDragHandle(el, getY) {
          return _react2.default.createElement(
            _DragHandle2.default,
            {
              onMouseDown: function onMouseDown(e) {
                return _this3._handleMouseDown(key, getY(), e);
              },
              onTouchStart: function onTouchStart(e) {
                return _this3._handleTouchStart(key, getY(), e);
              }
            },
            el
          );
        };
        var height = _this3._heights.get(key) || DEFAULT_HEIGHT;
        return _react2.default.createElement(_reactMotion.Motion, {
          style: style, key: key,
          children: function children(_ref2) {
            var itemSelected = _ref2.itemSelected,
                anySelected = _ref2.anySelected,
                y = _ref2.y;
            return _react2.default.createElement(_MoveContainer2.default, {
              ref: (0, _reactSaveRefs2.default)(_this3._itemRefs, key),
              y: useAbsolutePositioning ? y : null,
              template: template,
              padding: padding,
              item: item,
              itemSelected: itemSelected,
              anySelected: anySelected,
              height: height,
              zIndex: unsetZIndex && !useAbsolutePositioning ? 'auto' : lastDrag && lastDrag.itemKey === key ? list.length : i,
              makeDragHandle: makeDragHandle,
              commonProps: commonProps
            });
          }
        });
      });

      var adjustScroll = 0;
      if (!dragging && lastDrag && useAbsolutePositioning) {
        var dragIndex = this._getDragIndex();
        adjustScroll = (0, _reactMotion.spring)(this._getDistance(0, dragIndex, false) - lastDrag.mouseY, springConfig);
      }

      var fullContainerHeight = this._getDistance(0, list.length, false) + 'px';
      return _react2.default.createElement(
        'div',
        { style: { position: 'relative' } },
        _react2.default.createElement(_reactMotion.Motion, {
          style: { adjustScroll: adjustScroll, anySelected: anySelected },
          onRest: function onRest() {
            if (!dragging) {
              _this3._heights.clear();
              _this3.setState({ useAbsolutePositioning: false });
            }
          },
          children: function children(_ref3) {
            var adjustScroll = _ref3.adjustScroll;
            return _react2.default.createElement(
              'div',
              {
                style: {
                  display: useAbsolutePositioning ? 'block' : 'none',
                  height: useAbsolutePositioning ? fullContainerHeight : '0px'
                }
              },
              container && _react2.default.createElement(_OnUpdate2.default, { cb: function cb() {
                  if (!dragging && lastDrag && useAbsolutePositioning) {
                    _this3._adjustScrollAtEnd(adjustScroll);
                  }
                } })
            );
          }
        }),
        children
      );
    }
  }]);
  return DraggableList;
}(_react2.default.Component);

DraggableList.propTypes = {
  itemKey: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]).isRequired,
  template: _propTypes2.default.func,
  list: _propTypes2.default.array.isRequired,
  onMoveEnd: _propTypes2.default.func,
  container: _propTypes2.default.func,
  springConfig: _propTypes2.default.object,
  padding: _propTypes2.default.number,
  unsetZIndex: _propTypes2.default.bool,
  autoScrollMaxSpeed: _propTypes2.default.number.isRequired,
  autoScrollRegionSize: _propTypes2.default.number.isRequired,
  commonProps: _propTypes2.default.object
};
DraggableList.defaultProps = {
  springConfig: { stiffness: 300, damping: 50 },
  padding: 10,
  unsetZIndex: false,
  autoScrollMaxSpeed: 15,
  autoScrollRegionSize: 30
};
exports.default = DraggableList;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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